/*
 * Copyright 2024 Apollo Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package com.ctrip.framework.apollo.build.sql.converter;

import java.util.StringJoiner;

public class SqlTemplateGist {

  private final String autoGeneratedDeclaration;

  private final String h2Function;

  private final String setupDatabase;

  private final String useDatabase;

  SqlTemplateGist(Builder builder) {
    this.autoGeneratedDeclaration = builder.autoGeneratedDeclaration;
    this.h2Function = builder.h2Function;
    this.setupDatabase = builder.setupDatabase;
    this.useDatabase = builder.useDatabase;
  }

  public static Builder builder() {
    return new Builder();
  }

  public Builder toBuilder() {
    Builder builder = new Builder();
    builder.autoGeneratedDeclaration = this.autoGeneratedDeclaration;
    builder.h2Function = this.h2Function;
    builder.setupDatabase = this.setupDatabase;
    builder.useDatabase = this.useDatabase;
    return builder;
  }

  public String getAutoGeneratedDeclaration() {
    return this.autoGeneratedDeclaration;
  }

  public String getH2Function() {
    return this.h2Function;
  }

  public String getSetupDatabase() {
    return this.setupDatabase;
  }

  public String getUseDatabase() {
    return this.useDatabase;
  }

  @Override
  public String toString() {
    return new StringJoiner(", ", SqlTemplateGist.class.getSimpleName() + "[", "]")
        // fields
        .add("autoGeneratedDeclaration='" + this.autoGeneratedDeclaration + "'")
        .add("h2Function='" + this.h2Function + "'")
        .add("setupDatabase='" + this.setupDatabase + "'")
        .add("useDatabase='" + this.useDatabase + "'")
        .toString();
  }

  public static final class Builder {

    private String autoGeneratedDeclaration;
    private String h2Function;
    private String setupDatabase;
    private String useDatabase;

    Builder() {
    }

    public Builder autoGeneratedDeclaration(String autoGeneratedDeclaration) {
      this.autoGeneratedDeclaration = autoGeneratedDeclaration;
      return this;
    }

    public Builder h2Function(String h2Function) {
      this.h2Function = h2Function;
      return this;
    }

    public Builder setupDatabase(String setupDatabase) {
      this.setupDatabase = setupDatabase;
      return this;
    }

    public Builder useDatabase(String useDatabase) {
      this.useDatabase = useDatabase;
      return this;
    }

    public SqlTemplateGist build() {
      return new SqlTemplateGist(this);
    }
  }
}
