# Getting started  guide
Please download the file from https://drive.google.com/file/d/1T5ll1DbZK5rh505cGS9vatUbls37rmXv/view?usp=sharing (the checksum is available on https://drive.google.com/file/d/1KdCjd9-_poyRVm2jxCGu0xCTuVG54if7/view?usp=sharing; use the `sha256sum` command to verify) and expand it into an appropriate directory. Inside, you will find the `empirical` directory, which contains the following files:

 - A spreadsheet named `programming25_supplementary_material.xlsx`
 - A directory named `JPAEntities/`
 - A directory named `repositories/`

This artifact does not include any automation tools; i.e., the study was conducted *manually* by one of the authors, and different results can be produced if the categorization (explained below) is performed by others (as noted in the "Threats to validity" paragraph in Section 6).

# Overview of the claim
In the paper, we proposed a new schema evolution language designed for persistent objects. The evaluation consists of two parts: (1) formal definitions and proofs of certain required properties, and (2) an empirical study targeting the evolution of real open-source Java Persistence API (JPA) software. The former is covered in the paper itself, while this artifact is provided for the latter. In Section 6, we claimed:

 - By classifying the differences between declarations before and after a commit of each JPA class in the repository, we found that our evolution language covers a large part of existing evolution scenarios regarding persistent objects. We also identified some evolution scenarios that are not supported by our evolution language due to the expressiveness limitations.

# Instructions
For this empirical study, we analyzed the evolution histories of the following open-source projects, covering commits from the first occurrence of any JPA `@Entity` classes to the last commit before Mar. 27th, 2024.

- Broadleaf Commerce
- Keycloak
- Apollo Config

The submitted artifact includes
 - **Spreadsheet**:
 Details of our categorization are provided in `programming25_supplementary_material.xlsx`.
 - **Entity Class Versions**:
 Each version of `javax.persistence.Entity` (`jakarta.persistence.Entity`) classes can be found in the  `JPAEntities/` directory.
   * **Broadleaf Commerce**:
 Entity classes are located under `broadleaf/persistent/X/Y`, where `X` is the class name and `Y` is the version number (starting from 1; this is not the software version)
   * **Keycloak**:
   Entity classes are located under `keycloak/persistent/X/Y`, with the same naming convention as above.
   * **Apollo Config**:
   Entity classes are located under `apollo/persistent/X/Y`, with the same naming conventions as above.
 - **Repository Clones**:
 GitHub clone of the respective projects are stored in the `repositories/` directory:
   * **Broadleaf Commerce**: `broadleaf/BroadleafCommerce`
   * **Keycloak**: `keycloak/keycloak`
   * **Apollo Config**: `apolloconfig/apollo`
 
The study involves manually categorizing the delta (e.g., the output of the `diff` command) of each class between commits into the following categories:
 
 - Non-code edits (such as edits on comments)
 - Computational changes (modifications not affecting the database schema)
 - Non-structural schema evolution (such as changes in indexes and key constraints)
 - field (column) addition
 - field (column) type change
 - field (column) deletion
 - rename field (column)
 - rename class (table)
 - new inheritance
 - merge inheritance
 - change mapping of inheritance relations to database tables (e.g., from `@MappedSuperclass` to the `JOINED` strategy)
 - new component class (i.e., extracting several fields to form a new component class)
 - Making fields as a collection (i.e., converting fields into a key  value mapping, such as `Map<String, String> attributes;`
 
A single delta may fall into multiple categories. When determining the appropriate categories is difficult based solely on the delta, consult the repository for related changes in other classes.

 CAUTION: *The included repository clones are provided solely for long-term verifiability of this study. Please do NOT use them for any other purposes.*
 