# Microscopy data presentation 

## Why take this course

This course is motivated by and follows [a publication](https://rdcu.be/dl9Z8) about best practices for publishing bioimaging data and corresponding analyses. In this course we focus on the scientific presentation of microscopy image data. The skills taught in this course are critical for any scientists that need to communicate their image-based scientific findings to their colleagues, e.g. in a lab meeting, or to a wider audience, e.g. in a publication. 

## Teaching aims

After taking this course, the participants should be able to:
- Responsibly choose which image data to present
- Responsibly choose image rendering settings
- Add critical image metadata to their figures

## Target audience

Scientists that use microscopy data in their research

## Prerequisites

* Experience acquiring microscopy data is required
* Basics skills of understanding and inspecting microscopy data are recommended

## IT setup

This course can be conducted on any computer with internet access, where the owners have the rights to install a few open-source sof
tware packages.

## Dates

YEAR MONTH DAY 

## Schedule

HH:MM - HH:MM Click-along practical sessions

### Timing

- The below material consist of N modules.
- Typically one module can be taught in 25 - 45 minutes, depending on how many of the module's activities are taught and depending on whether participants would mainly follow along or also execute an activity independently (see the below "teaching tips" for more details on this)
- It is recommended to do at least one break

## Trainers

- Name (Institute)
- ...

## Training material

### Image manipulations

For presenting an image you may not always want to show the whole image, but sometimes zoom in on a specific part or display the image flipped or rotated, e.g. for aesthetic reasons. In this part of the course we learn how to perform such operations and also discuss whether they are scientifically sound. 

1. [Image cropping TODO](https://neubias.github.io/training-resources/pixels/index.html)
  - https://github.com/NEUBIAS/training-resources/issues/634 
1. [Image similarity transformations TODO](https://neubias.github.io/training-resources/datatypes/index.html) 
  - 

### Image rendering settings

1. [Lookup tables](https://neubias.github.io/training-resources/lut/index.html)
1. [Multi-channel images](https://neubias.github.io/training-resources/multichannel_images/index.html)
1. [Spatial image calibration](https://neubias.github.io/training-resources/spatial_calibration/index.html) 
1. [Volume slicing](https://neubias.github.io/training-resources/volume_slicing/index.html)
1. [Projections](https://neubias.github.io/training-resources/projections/index.html)

## Teaching tips

Please have a look at this [collection of general teaching tips](https://github.com/NEUBIAS/training-resources/blob/master/TEACHING_TIPS.md) for the above training material.
