# Microscopy data inspection 

## Why take this course

For microscopy based scientific discovery it is critical to be able to quantitatively inspect bioimaging data, because it is important to judge whether the intended measurements are properly captured by the acquired data. Often times one realises that sample preparation and acquisition parameters could be improved; in fact, microscopy data acquisition and inspection are typically an iterative process that needs to be repeated several times until optimal imaging data is acquired for the scientific question at hand.

## Teaching aims

After taking this course, the participants should be able to:
- Open a microscopy image and inspect the pixel values
- Responsibly configure the display settings for rendering the pixel values
- Check the quality of a microscopy image in terms of dynamic range
- Inspect and visualise an image's spatial calibration
- Deal with multi-channel and volumetric images

## Target audience

Scientists that use microscopy data in their research

## Prerequisites

* Some experience acquiring microscopy data
* No computational skills are required

## IT setup

This course can be conducted on any computer with internet access, where the owners have the rights to install a few open-source software packages.

## Dates

YEAR MONTH DAY 

## Schedule

HH:MM - HH:MM Click-along practical sessions

### Timing

- The below material consist of N modules.
- Typically one module can be taught in 25 - 45 minutes, depending on how many of the module's activities are taught and depending on whether participants would mainly follow along or also execute an activity independently (see the below "teaching tips" for more details on this)
- It is recommended to do at least one break

## Trainers

- Name (Institute)
- ...

## Training material

1. [Digital image basics](https://neubias.github.io/training-resources/pixels/index.html)
1. [Image data types](https://neubias.github.io/training-resources/datatypes/index.html) 
1. [Lookup tables](https://neubias.github.io/training-resources/lut/index.html)
1. [Multi-channel images](https://neubias.github.io/training-resources/multichannel_images/index.html)
1. [Spatial image calibration](https://neubias.github.io/training-resources/spatial_calibration/index.html) 
1. [Volume slicing](https://neubias.github.io/training-resources/volume_slicing/index.html)
1. [Projections](https://neubias.github.io/training-resources/projections/index.html)

## Teaching tips

Please have a look at this [collection of general teaching tips](https://github.com/NEUBIAS/training-resources/blob/master/TEACHING_TIPS.md) for the above training material.
