# 2018 May 7th-9th: Basics of Image Analysis using ImageJ

## Location:

ATC Computer Training Lab 

## Computers

Computers with ImageJ and course data will be installed. Thus, you do not need to bring your laptop.

If you prefer to work on your own computer, please:

- Install Fiji: https://imagej.net/Fiji/Downloads
- Download course material: https://github.com/tischi/imagej-courses/archive/master.zip
  - Please download again on Monday morning as there will most likely be some last minute changes!

## Prerequisites

In order to save some time, and since many of you took part in the ALMF Basics in Microscopy courses, we will not repeat what has been taught there already. If you did not attend it would be good if you could have a look at the material:

- Basic handling of the [ImageJ](https://fiji.sc/) software 
- [Image inspection and handling](https://github.com/tischi/imagej-courses/blob/master/practicals/basic-image-inspection-and-handling.md)
- [3D image inspection](https://github.com/tischi/imagej-courses/blob/master/practicals/3D-image-inspection.md)

But, don't worry, even if you don't know above material you'll be able to follow the course.

## Schedule

### Monday May 7th

| Time | Topic |
|------|-------|
| 09:30 - 10:00 | Welcome and self-introduction |
| 10:00 - 12:30 | Practical: [Basics of intensity measurements](https://github.com/tischi/imagej-courses/blob/master/practicals/intensity-quantification.md) |
| 12:30 - 13:30 | Lunch break |
| 13:30 - 15:00 | Practical: [Image segmentation: Manual thresholding, Signal to noise, Image filtering](https://github.com/tischi/imagej-courses/blob/master/practicals/image-segmentation.md) |
| 15:30 - 16:30 | Practical: [Image segmentation: Automated local background subtraction](https://github.com/tischi/imagej-courses/blob/master/practicals/workflow-2d-intracellular-spot-detection.md#local-background-subtraction-) |
| 16:30 - 17:30 | Practical: [Image segmentation: Automated global thresholding](https://github.com/tischi/imagej-courses/blob/master/practicals/image-segmentation.md#automated-global-thresholding)|
| 00:00 - 00:00 | Recommended home-work: [Intensity quantification: Automated local background subtraction](https://github.com/tischi/imagej-courses/blob/master/practicals/automated-local-background-subtraction-for-intensity-quantifications.md#intensity-measurements-with-automated-local-background-subtraction--) |

### Tuesday May 8th

| Time | Topic |
|------|-------|
| 09:30 - 12:30 | Practical: [Workflow for intracellular object quantification](https://github.com/tischi/imagej-courses/blob/master/practicals/workflow-2d-intracellular-spot-detection.md#workflow-autophagosome-quantification) | 
| 12:30 - 13:30 | Lunch break |
| 13:30 - 14:30 | Practical: [3D image analysis](https://github.com/tischi/imagej-courses/blob/master/practicals/3D-analysis.md) |
| 14:30 - 15:30 | Brief lectures & demonstrations: [Supervised pixel classification](https://github.com/tischi/imagej-courses/blob/master/practicals/supervised-pixel-classification.md#supervised-pixel-classification), [Supervised object classification](https://github.com/tischi/imagej-courses/blob/master/practicals/supervised-object-classification.md#supervised-object-classification), [Registration](https://github.com/tischi/imagej-courses/blob/master/practicals/image-registration.md), Stitching, Dealing with complex data formats |
| 15:30 - 16:15 | Practical: [Colocalization](https://github.com/tischi/imagej-courses/blob/master/practicals/colocalisation.md#colocalisation) |
| 16:15 - 17:30 | Practical: [Tracking using TrackMate](https://github.com/tischi/imagej-courses/blob/master/practicals/tracking-with-trackmate.md)  |

### Wednesday May 9th

| Time | Topic |
|------|-------|
| 09:30 - 11:30 | Practical: [Macro recording and scripting in ImageJ](https://github.com/tischi/imagej-courses/blob/master/practicals/macro-recording.md) |
| 11:30 - 12:30 | Brief mentionings: [CellProfiler](http://cellprofiler.org/tutorials/), [Imaris](http://www.bitplane.com/learning), [KNIME](https://www.knime.com/community/image-processing), [shinyHTM](https://github.com/hmbotelho/shinyHTM#shinyhtm) |
| 12:30 - 13:30 | Lunch break |
| 13:30 - 17:00 | Practical: Work on own data (optional session) |

### Further information

Don't worry, there will be coffee breaks, one in the morning and one in the afternoon, even though they are not explicitly scheduled :-)



