# Scientific bioimage data inspection and presentation

## Why take this course

For microscopy based scientific discovery it is critical to be able to quantitatively inspect and present bioimaging data. This is important at many stages, ranging from looking at the data yourself, presenting the data to lab members and finally creating a figure for a publication.

This course will teach this using Fiji.

## Target audience

Scientists that may use microscopy data in their research.

## Prerequisites

* No computational skills are required
* Computer with Fiji installed
* Internet access
* For the afternoon bring own 2D (multi-channel) microscopy raw data

## Dates

### EMBL/ALMF/CBA Microscopy Course 2024

2024 February 21, Wednesday 

## Schedule

09:30 - 12:30 hybrid click-along sessions
14:00 - 16:00 work on your own data

## Trainers

- Christian Tischer (EMBL Heidelberg)
- Arif Khan (EMBL Heidelberg)

## Morning session teaching content

### 9:30 - 11:30 (including break)

1. [Volume slicing](https://neubias.github.io/training-resources/volume_slicing/index.html)
1. [Projections](https://neubias.github.io/training-resources/projections/index.html)
1. [Volume rendering](https://neubias.github.io/training-resources/volume_viewer/index.html)

### 11:30 - 12:30

1. Using Blender for 3D rendering
    - [tif2blender](https://github.com/oanegros/tif2blender) blender add-on demonstration. This will cover installing blender + tif2blender, loading data and changing some key parameters. 
    - Further information in the [video tutorial](https://www.youtube.com/watch?v=TCQojYEYxVo) and [text tutorial](https://github.com/oanegros/Blender_for_Biologists_2023).

### Timing

Available time: 3 hrs = 180 minutes; 15 minutes break => 165 minutes total
