# Scientific bioimage data inspection and presentation

## Why take this course

For microscopy based scientific discovery it is critical to be able to quantitatively inspect and present bioimaging data. This is important at many stages, ranging from looking at the data yourself, presenting the data to lab members and finally creating a figure for a publication.

This course will teach this using Fiji.

## Target audience

Scientists that may use microscopy data in their research.

## Prerequisites

* No computational skills are required
* Computer with Fiji installed
* Internet access
* For the afternoon bring own 2D (multi-channel) microscopy raw data

## Dates

### EMBL/ALMF/CBA Microscopy Course 2024

2024 February 20 

## Schedule

09:30 - 12:30 hybrid click-along sessions
14:00 - 16:00 work on your own data

## Trainers

- Christian Tischer (EMBL Heidelberg)
- Arif Khan (EMBL Heidelberg)

## Morning session teaching content

1. [Scientfic image data presentation](https://neubias.github.io/training-resources/image_inspection_and_presentation/index.html)
    - Only discuss the main figure for motivation of the course: to create the figure all the below modules need to be learned
1. [Digital image basics](https://neubias.github.io/training-resources/pixels/index.html)
1. [Image data types](https://neubias.github.io/training-resources/datatypes/index.html) 
1. [Lookup tables](https://neubias.github.io/training-resources/lut/index.html)
1. [Multichannel images](https://neubias.github.io/training-resources/multichannel_images/index.html)
1. [Spatial image calibration](https://neubias.github.io/training-resources/spatial_calibration/index.html) 
1. [Image file formats](https://neubias.github.io/training-resources/image_file_formats/index.html)
1. [Scientfic image data presentation](https://neubias.github.io/training-resources/image_inspection_and_presentation/index.html)
    - Now we are ready to perform the module activity and create the scientific image presentation

### Timing

Available time: 3 hrs = 180 minutes; 15 minutes break => 165 minutes total
Number of modules: 7 (the first one is just short motivation and thus not counted)
Thus, average time per module: 165 min / 7 = 23 minutes (should be fine) 

