# Python based image analysis using skimage and napari

## Why take this course
In this course, you will be introduced to essential concepts of image analysis. We will primarely use python and take advantage of the large and growing number of specialized python libraries. Learning python is useful in general because it is currently the most popular language for scientific computing, data science, and machine learning. Since a few years *napari* allows powerful and flexible n-dimensional image data visualisation, including overlay of segmentation and annotation layers.

## Venue

MPI for Multidisciplinary Sciences, Am Fassberg 11, Göttingen

Facility for light microscopy, Tower 2, SOG, Room 006-a (see also https://www.mpinat.mpg.de/4196282/locations).

Ring the bell at "Mikr. lebender Zellen Lenart".

## Teachers
Antonio Politi, MPI-NAT, Goettingen (apoliti@mpinat.mpg.de)

## Course time schedule
* 12.06.2024
  * 10:00 - 12:00 - Lecture and hands-on
  * 12:00 - 13:00 - Lunch break
  * 13:00 - 15:00 - Lecture and hands-on
  * 15:00 - 15:30 - Coffee break
  * 15:30 - 17:00 - Lecture and hands-on
* 13.06.2024
  * 10:00 - 12:00 - Lecture and hands-on
  * 12:00 - 13:00 - Lunch break
  * 13:00 - 15:00 - Lecture and hands-on
  * 15:00 - 15:30 - Coffee break
  * 15:30 - 17:00 - Lecture and hands-on 

## Prerequisites
* You should know all the topics mentioned in the **Learn the Basics** section of the [Learn Python](https://www.learnpython.org/en/Welcome) website (you may skip "Classes and Objects" and "Modules and Packages").
* Please practice running code in a Jupyter Notebook following this Jupyter Lab [guide](https://jupyter.org/try-jupyter/lab/) path [notebooks> Intro.ipynb]. For plain Jupyter Notebook (old interface) follow this [guide](https://jupyter.org/try-jupyter/notebooks/?path=notebooks/Intro.ipynb). 
## IT Setup
For the course you will need to bring your laptop (you will need WiFi and eduroam). 

Please, before the course use the `conda` platform to install skimage and napari on your laptop, following [these instructions](https://neubias.github.io/training-resources/tool_installation/index.html#skimage_napari). 

Do also install a recent version of FiJi following [these instructions](https://neubias.github.io/training-resources/tool_installation/index.html#imagej).

Do login with your university/mpinat/... account on https://chat.gwdg.de. We will use RocketChat to exchange links and course material. 

## Modules
The teaching will use the online material https://neubias.github.io/training-resources/all-modules/. Which modules we will address will be listed soon. 

# 12.06.2024 Morning session

1. [Digital image basics](https://neubias.github.io/training-resources/pixels/index.html)
1. [Lookup tables](https://neubias.github.io/training-resources/lut/index.html)
1. [Spatial image calibration](https://neubias.github.io/training-resources/spatial_calibration/index.html) 
1. [N-dimensional images](https://neubias.github.io/training-resources/multidimensional_image_basics/index.html) (self study)

# 12.06.2024 afternoon session
1. [Image data types](https://neubias.github.io/training-resources/datatypes/index.html)
1. [Image projections](https://neubias.github.io/training-resources/projections/index.html)
1. [Segmentation](https://neubias.github.io/training-resources/segmentation/index.html)
1. [Manual thresholding](https://neubias.github.io/training-resources/binarization/index.html)
1. [Automated thresholding](https://neubias.github.io/training-resources/auto_threshold/index.html) (self study)
1. [Connected component labeling](https://neubias.github.io/training-resources/connected_components/index.html)

# 13.06.2024 morning session
1. [Object shape measurements](https://neubias.github.io/training-resources/measure_shapes/index.html)
1. [Workflow: Basic 2D object analysis](https://neubias.github.io/training-resources/workflow_segment_2d_nuclei_measure_shape/index.html) (self study)
1. [Object intensity measurement](https://neubias.github.io/training-resources/measure_intensities/index.html)

# 13.06.2024 afternoon session
1. [Image neighborhood filtering](https://neubias.github.io/training-resources/filter_neighbourhood/index.html)
1. [Median filter](https://neubias.github.io/training-resources/median_filter/index.html)
1. [Local background subtraction](https://neubias.github.io/training-resources/local_background_correction/index.html)
1. [Morphological filters](https://neubias.github.io/training-resources/filter_morphological/index.html)
1. [Workflow: 2D noisy object segmentation and filtering](https://neubias.github.io/training-resources/workflow_segment_2d_noisy_nuclei_filter_objects_measure_shape/index.html)
