# Scientific bioimage data inspection and presentation

## Why take this course

For microscopy based scientific discovery it is critical to be able to quantitatively inspect and present bioimaging data. This is important at many stages, ranging from looking at the data yourself, presenting the data to lab members and finally creating a figure for a publication.

This course will teach this using Fiji.

## Target audience

Scientists that may use microscopy data in their research.

## Prerequisites

* No computational skills are required
* Computer with Fiji installed
* Internet access

## Dates

### EMBL PreDoc Course 2023

2023 October 23 (repeated at 24, 25, 26)

## Schedule

14:00 - 16:00 in person click-along sessions

## Trainers

- Christian Tischer (EMBL Heidelberg)
- Arif Khan (EMBL Heidelberg)
- Ziqiang Huang (EMBL Heidelberg)
- Nima Vakili (EMBL Heidelberg)

## Teaching content

1. [Scientfic image data presentation](https://neubias.github.io/training-resources/image_inspection_and_presentation/index.html)
    - Only discuss the main figure for motivation of the course: to create the figure all the below modules need to be learned
1. [Digital image basics](https://neubias.github.io/training-resources/pixels/index.html)
1. [Image data types](https://neubias.github.io/training-resources/datatypes/index.html) 
1. [Lookup tables](https://neubias.github.io/training-resources/lut/index.html)
1. [Spatial image calibration](https://neubias.github.io/training-resources/spatial_calibration/index.html) 
1. [Image file formats](https://neubias.github.io/training-resources/image_file_formats/index.html)
1. [Scientfic image data presentation](https://neubias.github.io/training-resources/image_inspection_and_presentation/index.html)
    - Now we are ready to perform the module activity and create the scientific image presentation
    - TODO the activity needs to be adapted: https://github.com/NEUBIAS/training-resources/issues/606 

## Teaching tips

- Most of the above modules have several activities. We recommend that the teacher goes through each module before the course and selects some of the activities after trying them out.
