- Open an image with objects of different shapes (see activity preface) 
- Use `Analyse > Tools > ROI Manager` to open the ROI manager
- Use the ROI tools, e.g. the Polygon selection in the Fiji menu bar to delineate some objects in the image 
- Use `ROI Manager > Add` to record each ROI
- Use `ROI Manager > Rename...` to give them meaningful names
- For easier region identification use `ROI Manager > More > Options` 
  - [X] Use ROI names as labels
- Display all regions using `ROI Manager`
  - [X] Show All
  - [X] Labels
- Once all are added use `ROI Manager > More > Save...` to store the ROIs
  - This is important to document your work; the ROI file can be opened via drag&drop on Fiji
- Use `Analyse > Set Measurements` to configure [what to measure](https://imagej.net/ij/docs/menus/analyze.html#set):
  - [X] Area
  - [X] Centroid
  - [X] Perimeter 
  - [X] Fit Ellipse
  - [X] Feret's Diameter
  - [X] Shape Descriptors 
  - [X] Display label (adds a column with the object name)
- Use `ROI Manager > More > Multi Measure` to measure all ROIs at once
- Use `Image > Properties` to check the image calibration
- Use `Results > File > Rename` to indicate the image calibration in the table name
  - Use `Image > Properties` to change the image to pixel units
- Measure all ROIs again and change the table name to indicate the calibration   
- Understand all the measurements
  - Compare calibrated and pixel unit measurements
  - Go through the columns and see which object has an extreme value and why 
  - See [ImageJ measurements documentation](https://imagej.net/ij/docs/menus/analyze.html#set) 
  - Select one object and use `Edit > Selection > Convex Hull` to see the convex hull 
