**Requirements:** Fiji with MoBIE update site

- Open a MoBIE project containing correlative data
  - `[ Plugins › MoBIE › Open › Open MoBIE Project... ]`
    - `Project Location` `https://github.com/mobie/clem-example-project/`
- Explore the transformation from viewer to global space:
  - Log the current `dgT` and `gvT`
    - BDV context menu: `Log Source Transforms` & `Log Current Location`
  - Zoom in
    - BDV: `arrow up`
  - Log `dgT` and `gvT` again and appreciate that only the `gvT` has changed.
     - Appreciate that the first component of the `gvT` is bigger, corresponding to the higher zoom level.
  - Add another image:
    - MoBIE UI: From the `tomogram` drop-down choose `tomo_37_hm` and click `[ view ]`
  - Appreciate that navigation (i.e. finding the `tomo_37_hm` image) in large correlative data sets is challenging.
  - Focus on the `tomo_37_hm` image:
    - MoBIE UI: `tomo_37_hm` click `[ F ]`
- Explore heterogeneous voxel sizes
  - Toggle off interpolation
    - BDV: `i` (it should say "nearest neighbor interpolation")
  - Zoom in a bit more
    - BDV: `arrow up`
  - Move to the edge of the `tomo_37_hm`
    - BDV: Mouse `right button drag`
  - Alternatively copy below `gvT` transform into the `location` field and click `[ move ]`
    - `{"normalizedAffine":[0.4963397000728218,0.0,0.0,-108.59369157880992,0.0,0.4963397000728218,0.0,-152.83843100300004,0.0,0.0,0.4963397000728218,3.865989923867204E-4],"timepoint":0}`
  - Appreciate that the voxels of the `em-overview` are visible (and are larger than the voxels of `tomo_37_hm`)
  - This information is encoded in the transformations from data space to global space (dgT):
    - [em-overview dgT transformation](https://s3.embl.de/yeast-clem/hela/images/ome-zarr/em-overview.ome.zarr/.zattrs)
    - [tomo_37_nm dgT transformation](https://github.com/mobie/clem-example-project/blob/66064176fa39b9f7d0e94f855f1c4b7d226812d4/data/hela/images/bdv-n5-s3/tomo_37_hm.xml#L38)
- Explore heterodimensional (2D & 3D) rendering
  - Look at the data from the side
    - BDV: `shift y`
  - Zoom out until you see the edges of `em-overview` along the z-axis
    - BDV: `arrow down`
  - Alternatively copy below `gvT` transform into the `location` field and click `[ move ]`
    - `{"normalizedAffine":[-0.0020015317086036193,-0.01932460609735281,-5.114194702548178E-19,6.3944917447396445,-5.114194702548184E-19,-7.789826789933008E-19,0.019427983168573904,-0.0015838942648179167,-0.01932460609735281,0.0020015317086036193,-7.789826789933008E-19,3.638083567375694],"timepoint":0}`
  - Appreciate that the voxels of `em-overview` are rendered 300 nm along the z-axis.
  - This is specified [here](https://github.com/mobie/clem-example-project/blob/de1be447b48e0ce95a302dd1fe33d9b725cd82dd/data/hela/dataset.json#L8950)
- Change the `dgT` ("registration") of one image:
  - Focus on `tomo_37_hm`
    - MoBIE UI: `tomo_37_hm` click `[ F ]`
  - Log the `dgT`
    - BDV context menu: `Log Source Transformations`
  - Change the `dgT` of `tomo_37_hm`:
    - BDV context menu: `Registration - Manual Transform`
    - Follow the instructions to change the location of `tomo_37_hm`
  - Log the `dgT` again (s.a.) and appreciate that it has changed.
