""" This module is responsible for rendering the image-alt attack template. """

import common


def get_network_img_groups(adblocker):
    """Get generic network groups with resource type image"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]['image-alt']["generic-network"]
        if f.get("resource", None) == "image"
    ]


def render(adblocker):
    """Render the attack page"""

    network_imgs = get_network_img_groups(adblocker)

    common.render_attack_template(
        f"image-alt-{adblocker}",
        "image-alt.html",
        network_imgs=network_imgs,
        adblocker=adblocker,
    )
