"""CSS Animation attack page builder"""

import common

def get_network_iframe_groups(adblocker):
    """Get generic network groups with resource type iframe"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]['lazy-image-and-animation']["generic-network"]
        if f.get("resource", False) == "iframe"
    ]

def get_network_img_groups(adblocker):
    """Get generic network groups with resource type image"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]['lazy-image-and-animation']["generic-network"]
        if f.get("resource", None) == "image"
    ]
    
def get_css_class_group(adblocker):
    """Get the CSS class group"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]['lazy-image-and-animation']["generic-cosmetic"]
        if f.get("by", False) == "class"
    ]
    
def get_css_id_group(adblocker):
    """Get the CSS id group"""

    return [
        f
        for f in common.ADBLOCKER_DATA[adblocker]['lazy-image-and-animation']["generic-cosmetic"]
        if f.get("by", False) == "id"
    ]


def render(adblocker): 
    """Render the attack page"""

    network_iframes = get_network_iframe_groups(adblocker)
    network_imgs = get_network_img_groups(adblocker)
    css_classes = get_css_class_group(adblocker)
    css_ids = get_css_id_group(adblocker)
    
    common.render_attack_template(
        f"css-animation-{adblocker}",
        "css-animation.html",
        service_worker="css-animation",
        network_imgs=network_imgs,
        network_iframes=network_iframes,
        css_classes=css_classes,
        css_ids=css_ids,
        adblocker=adblocker,
    )
