# Filter-List Fingerprinting Attacks POCs

This project presents a proof of concept implementations of the filter-list fingerprinting attacks proposed in the paper "Anonymous Paper" by Anonymous Authors.

The attacks are implemented within HTML pages using CSS and with simulating the attacker server using browser service workers.

## Project Structure
The project is structured as follows:
- `deploy.sh`: Script to deploy the project to GitHub pages
- `watch.sh`: Script to start the development server
- `builder/`: Contains the source code of the project
    - `data/`: Contains the ad-blocker configurations (the rules used for fingerprinting)
    - `services/`: Contains the service workers used for the attacker server simulation
    - `static/`: Contains the static files (CSS and JS)
    - `templates/`: Contains the HTML templates for the attack pages
    - various Python scripts to generate the attack pages
- `public/`: Contains the generated attack pages ready to be hosted by a simple HTTP server


## Instructions
### Deploying

To deploy the project to GitHub pages, follow the steps below:

1. Push your changes to the main branch
2. Run the following command to deploy the changes to the gh-pages branch
```bash
bash deploy.sh
```

### Development

For local development, follow the steps below:

Run the following command to start the development server at http://localhost:8000
```bash
bash watch.sh
```