program processo

 implicit none
 integer  :: nl, error, i, np,ind
 real     :: dere,dema,ene,aa,re,row,roa,muw,gra,lam,sct,sce,scm,sca,etss, &
             refvel,alpha,arearif,arearifd,kla,kld,klae,klde,deki,sigma,scdv, &
             kldm,kldem,eps,arm
 real, dimension (:), allocatable   :: t,masja,masjw,cona,conw,epoa,epow, &
                                       ekia,intarea,vola,volw,ste, &
                                       ekt,ept,divi,ets,indi,ekiw,ekiwd
 real, dimension (:), allocatable   :: td,masjad,masjwd,epowd, &
                                       intaread,eptd,ektd,divid,sted,etsd,indid
 real, dimension (:), allocatable   :: klda,kldae,tr,intar

! conto le linee

 nl = 0
 open(2,file='channel.out')   !--> insert the correct file name
 do
   read(2,*,iostat=error)
   if (error == -1) exit
   nl = nl+1
 enddo
 close(2)

 write(*,*) ' Dammi Reynolds '
 read(*,*) re
 write(*,*) ' Dammi steepness'
 read(*,*) eps

 alpha = 0.33

 allocate(t(nl))   ! time
 allocate(masja(nl)) ! total species in air
 allocate(masjw(nl)) ! total species in water
 allocate(cona(nl))  ! average concentration in air
 allocate(conw(nl))  ! average concentration in water
 allocate(epoa(nl)) ! potential energy in air
 allocate(epow(nl)) ! potential energy in water
 allocate(ekia(nl))  ! kinetic energy in air
 allocate(ekiw(nl))  ! kinetic energy in water
 allocate(intarea(nl)) ! interface area
 allocate(vola(nl)) ! volume air
 allocate(volw(nl)) ! volume water
 allocate(ept(nl))  ! energia potenziale totale
 allocate(ekt(nl))  ! energia cinetica totale
 allocate(ste(nl))  ! termine contributo energie tensione superficiale
 allocate(divi(nl)) ! dissipazione viscosa in volume
 allocate(ets(nl))  ! energia di tensione superficiale da integrale budget
 allocate(indi(nl)) ! integrale diss viscosa

! dimensional variables

 allocate(td(nl))   ! time
 allocate(epowd(nl)) ! potential energy in water
 allocate(ekiwd(nl)) ! kinetic energy in water
 allocate(intaread(nl)) ! interface area
 allocate(masjad(nl)) ! total species in air
 allocate(masjwd(nl)) ! total species in water
 allocate(eptd(nl))  ! energia potenziale totale
 allocate(ektd(nl))  ! energia cinetica totale
 allocate(sted(nl))  ! termine contributo energie tensione superficiale
 allocate(divid(nl)) ! dissipazione viscosa in volume
 allocate(etsd(nl))  ! energia di tensione superficiale da integrale budget
 allocate(indid(nl)) ! integrale diss viscosa dimensionale

 row = 1000. 
 roa = 1.25
 muw = 0.001
 gra = 9.81
 lam = (re*muw/(row*sqrt(gra)))**(2./3.)
 refvel = sqrt(lam*gra)

 write(*,*) ' lunghezza = ',lam
 sct = sqrt(lam/gra)  ! scala tempi
 sce = row*gra*lam**4 ! scala energia totale
 scdv = row*gra*lam**4/sct ! scala termine dissipazione viscosa
 scm = lam**3   ! scala massa specie
 sca = lam**2   ! scala area interfaccia

 sigma = 1.0/15.0 ! coefficiente tensione superficiale delle simulazioni 

 open(2,file='channel.out')
 do i = 1,nl
   read(2,*) t(i), aa, aa, ekt(i), ept(i) , ste(i), divi(i), aa, aa, aa, aa, &
    ekia(i), ekiw(i), epoa(i), epow(i), aa, aa, aa, masja(i), masjw(i), &
    volw(i), vola(i), aa, intarea(i), aa

   ekt(i) = ekt(i)*1.250/1000.0
   ept(i) = ept(i)*1.250/1000.0 + 1.0

   epoa(i) = epoa(i)*1.250/1000.0
   epow(i) = epow(i)*1.250/1000.0 + 1.0 ! l'ultimo termine è la  
 !      correzione potenziale a t=00
   ekia(i) = ekia(i)*1.250/1000.0
   ekiw(i) = ekiw(i)*1.250/1000.0

   cona(i)  = masja(i)/vola(i)   ! concentrazione media nel volume
   conw(i)  = masjw(i)/volw(i)   ! concentrazione media nel volume

   td(i)    = sct*t(i)
   ekiwd(i) = sce*ekiw(i)
   epowd(i) = sce*epow(i)
   masjwd(i) = masjw(i)*scm
   masjad(i) = masja(i)*scm
   intaread(i) = sca*intarea(i)
   ektd(i) = sce*ekt(i)
   eptd(i) = sce*ept(i)
 enddo

 arearif = 0.50  
 arearifd = 0.50*sca

! integro energia tensione superficiale e dissipazione viscosa

 ets(1) = sigma*intarea(1)
 indi(1) = ekt(1)+ept(1)
 do i = 2,nl
   indi(i) = indi(i-1)+(divi(i)+divi(i-1))*(t(i)-t(i-1))/2.0
   ets(i)  = ets(i-1)+(ste(i)+ste(i-1))*(t(i)-t(i-1))/2.0
 enddo

! processo calcolando le derivate numeriche

! Variabili in uscita sui file derivati adimensionali

 np = 50 

 open(3,file='derivate-dim.dat')
 open(4,file='dati-dim.dat')
 open(5,file='derivate-adim.dat')
 open(6,file='dati-adim.dat')

 write(5,*) '# 1 tempo adim'
 write(5,*) '# 2 derivata temporale energia acqua'
 write(5,*) '# 3 derivata quantità specie in acqua'
 write(5,*) '# 4 area interfaccia'
 write(5,*) '# 5 gas transfer velocity basata su area nomimale'
 write(5,*) '# 6 gas transfer velocity basata su area effettiva'
 write(5,*) '# 7 dissipazione viscosa (totale - aria + acqua)'
 write(5,*) '# 8 energia tensione superficiale integrale '
 write(5,*) '# 9 energia tensione superficiale da area '
 write(5,*) '# 10 integrale dissipazione viscosa '

 write(6,*) '# 1 tempo adim'
 write(6,*) '# 2 energia cinetica+potenziale in acqua'
 write(6,*) '# 3 concentrazione media specie in acqua' 
 write(6,*) '# 4 quantità specie in acqua'
 write(6,*) '# 5 energia cinetica+potenziale in aria+acqua '

 write(3,*) '# 1 tempo dim'
 write(3,*) '# 2 tempo adim '
 write(3,*) '# 3 derivata temporale energia acqua'
 write(3,*) '# 4 derivata quantità specie in acqua'
 write(3,*) '# 5 area interfaccia'
 write(3,*) '# 6 gas transfer velocity basata su area nomimale'
 write(3,*) '# 7 gas transfer velocity basata su area effettiva'
 write(3,*) '# 8 dissipazione viscosa (totale - aria + acqua)'
 write(3,*) '# 9 integrale dissipazione viscosa '

 write(4,*) '# 1 tempo dim'
 write(4,*) '# 2 tempo adim'
 write(4,*) '# 3 energia cinetica+potenziale in acqua'
 write(4,*) '# 4 concentrazione media specie in acqua' 
 write(4,*) '# 5 quantità specie in acqua'
 write(4,*) '# 6 energia cinetica+potenziale in aria+acqua '

 ind = 0
 allocate(klda(nl),kldae(nl),tr(nl),intar(nl),source=0.0)
!
 do i = np+1,nl-np,np
   ene  = epow(i)+ekiw(i)
   dere = ((epow(i+np)+ekiw(i+np))-(epow(i-np)+ekiw(i-np)))/(t(i+np)-t(i-np))
   dema = (masjw(i+np)-masjw(i-np))/(t(i+np)-t(i-np))
   kla  = dema/(arearif*(conw(i)-alpha*(cona(i)))) 
   klae = dema/(intarea(i)*(conw(i)-alpha*(cona(i))))
   etss = sigma*intarea(i)

   write(5,*) t(i),dere,dema,intarea(i),kla,klae,divi(i),ets(i),etss,indi(i)
   write(6,*) t(i),epow(i)+ekiw(i),conw(i),masjw(i),ekt(i)+ept(i)

   ene  = epowd(i)+ekiwd(i)
   dere = ((epowd(i+np)+ekiwd(i+np))-(epowd(i-np)+ekiwd(i-np)))/ &
   (td(i+np)-td(i-np))
   deki = (ekiwd(i+np)-ekiwd(i-np))/(td(i+np)-td(i-np))
   dema = (masjwd(i+np)-masjwd(i-np))/(td(i+np)-td(i-np))
   kld  = dema/(arearifd*(conw(i)-alpha*(cona(i)))) 
   klde = dema/(intaread(i)*(conw(i)-alpha*(cona(i))))
!
   ind = ind +1
   klda(ind) = kld
   kldae(ind) = klde
   intar(ind) = intaread(i)
   tr(ind) = td(i)
!
   write(3,*) td(i),t(i),dere,dema,intaread(i),kld,klde,divi(i)*scdv,indi(i)*sce 
   write(4,*) td(i),t(i),epowd(i)+ekiwd(i),conw(i),masjwd(i),ektd(i)+eptd(i)
 enddo
 close(3)
 close(4)
 close(5)
 close(6)
!
! calcolo media gas transfer velocity 
!
 if (re .eq. 10000 .and. eps .eq. 0.25) then

  kldm = 0.
  kldem = 0.
  arm   = 0.
  do i = 1,ind-1
    if (tr(i) .ge. 0.20 .and. tr(i) .le. 0.550) then
     kldm = kldm + 0.5*(klda(i)+klda(i+1))*(tr(i+1)-tr(i))
     kldem = kldem + 0.5*(kldae(i)+kldae(i+1))*(tr(i+1)-tr(i))
     arm   = arm + 0.5*(intar(i)+intar(i+1))*(tr(i+1)-tr(i))
    endif
  enddo
  print * ,' media gas transfer velocity nom  = ',kldm/(0.550-0.20)
  print * ,' media gas transfer velocity real = ',kldem/(0.550-0.20)
  print * ,' media area interface dimens      = ',arm/(0.550-0.20)
  print * ,' media area interface increase    = ',((arm/(0.550-0.20))-intaread(1))/intaread(1)*100

 else if (re .eq. 40000 .and. eps .eq. 0.25) then

  kldm = 0.
  kldem = 0.
  arm   = 0.
  do i = 1,ind-1
    if (tr(i) .ge. 0.30 .and. tr(i) .le. 0.800) then
     kldm = kldm + 0.5*(klda(i)+klda(i+1))*(tr(i+1)-tr(i))
     kldem = kldem + 0.5*(kldae(i)+kldae(i+1))*(tr(i+1)-tr(i))
     arm   = arm + 0.5*(intar(i)+intar(i+1))*(tr(i+1)-tr(i))
    endif
  enddo
  print * ,' media gas transfer velocity nom  = ',kldm/(0.800-0.30)
  print * ,' media gas transfer velocity real = ',kldem/(0.800-0.30)
  print * ,' media area interface dimens      = ',arm/(0.800-0.30)
  print * ,' media area interface increase    = ',((arm/(0.800-0.30))-intaread(1))/intaread(1)*100

 else if (re .eq. 10000 .and. eps .eq. 0.37) then
!
  kldm = 0.
  kldem = 0.
  arm = 0.
  do i = 1,ind-1
    if (tr(i) .ge. 0.161 .and. tr(i) .le. 0.277) then
     kldm = kldm + 0.5*(klda(i)+klda(i+1))*(tr(i+1)-tr(i))
     kldem = kldem + 0.5*(kldae(i)+kldae(i+1))*(tr(i+1)-tr(i))
     arm   = arm + 0.5*(intar(i)+intar(i+1))*(tr(i+1)-tr(i))
    endif
  enddo
  print * ,' media gas transfer velocity nom  = ',kldm/(0.277-0.161)
  print * ,' media gas transfer velocity real = ',kldem/(0.277-0.161)
  print * ,' media area interface dimens      = ',arm/(0.277-0.161)
  print * ,' media area interface increase    = ',((arm/(0.277-0.161))-intaread(1))/intaread(1)*100
!
 else if (re .eq. 40000 .and. eps .eq. 0.37) then
!
  kldm = 0.
  kldem = 0.
  arm = 0.
  do i = 1,ind-1
    if (tr(i) .ge. 0.216 .and. tr(i) .le. 0.336) then
     kldm = kldm + 0.5*(klda(i)+klda(i+1))*(tr(i+1)-tr(i))
     kldem = kldem + 0.5*(kldae(i)+kldae(i+1))*(tr(i+1)-tr(i))
     arm   = arm + 0.5*(intar(i)+intar(i+1))*(tr(i+1)-tr(i))
    endif
  enddo
  print *, 'primo intervallo'
  print * ,' media gas transfer velocity nom  = ',kldm/(0.336-0.216)
  print * ,' media gas transfer velocity real = ',kldem/(0.336-0.216)
  print * ,' media area interface dimens      = ',arm/(0.336-0.216)
  print * ,' media area interface increase    = ',((arm/(0.336-0.216))-intaread(1))/intaread(1)*100

  kldm = 0.
  kldem = 0.
  arm = 0.
  do i = 1,ind-1
    if (tr(i) .ge. 0.336 .and. tr(i) .le. 0.400) then
     kldm = kldm + 0.5*(klda(i)+klda(i+1))*(tr(i+1)-tr(i))
     kldem = kldem + 0.5*(kldae(i)+kldae(i+1))*(tr(i+1)-tr(i))
     arm   = arm + 0.5*(intar(i)+intar(i+1))*(tr(i+1)-tr(i))
    endif
  enddo
  print *, 'secondo intervallo'
  print * ,' media gas transfer velocity nom  = ',kldm/(0.400-0.336)
  print * ,' media gas transfer velocity real = ',kldem/(0.400-0.336)
  print * ,' media area interface dimens      = ',arm/(0.400-0.336)
  print * ,' media area interface increase    = ',((arm/(0.400-0.336))-intaread(1))/intaread(1)*100

  kldm = 0.
  kldem = 0.
  arm = .0
  do i = 1,ind-1
    if (tr(i) .ge. 0.400 .and. tr(i) .le. 0.577) then
     kldm = kldm + 0.5*(klda(i)+klda(i+1))*(tr(i+1)-tr(i))
     kldem = kldem + 0.5*(kldae(i)+kldae(i+1))*(tr(i+1)-tr(i))
     arm   = arm + 0.5*(intar(i)+intar(i+1))*(tr(i+1)-tr(i))
    endif
  enddo
  print *, 'secondo intervallo'
  print * ,' media gas transfer velocity nom  = ',kldm/(0.577-0.400)
  print * ,' media gas transfer velocity real = ',kldem/(0.577-0.400)
  print * ,' media area interface dimens      = ',arm/(0.577-0.400)
  print * ,' media area interface increase    = ',((arm/(0.577-0.400))-intaread(1))/intaread(1)*100

!
 else if (re .eq. 10000 .and. eps .eq. 0.5) then
!
  kldm = 0.
  kldem = 0.
  arm = 0.
  do i = 1,ind-1
    if (tr(i) .ge. 0.0777 .and. tr(i) .le. 0.194) then
     kldm = kldm + 0.5*(klda(i)+klda(i+1))*(tr(i+1)-tr(i))
     kldem = kldem + 0.5*(kldae(i)+kldae(i+1))*(tr(i+1)-tr(i))
     arm   = arm + 0.5*(intar(i)+intar(i+1))*(tr(i+1)-tr(i))
    endif
  enddo
  print * ,' media gas transfer velocity nom  = ',kldm/(0.194-0.0777)
  print * ,' media gas transfer velocity real = ',kldem/(0.194-0.0777)
  print * ,' media area interface dimens      = ',arm/(0.194-0.0777)
  print * ,' media area interface increase    = ',((arm/(0.194-0.0777))-intaread(1))/intaread(1)*100
!
 else if (re .eq. 40000 .and. eps .eq. 0.5) then
!
  kldm = 0.
  kldem = 0.
  arm = 0.
  do i = 1,ind-1
    if (tr(i) .ge. 0.133 .and. tr(i) .le. 0.291) then
     kldm = kldm + 0.5*(klda(i)+klda(i+1))*(tr(i+1)-tr(i))
     kldem = kldem + 0.5*(kldae(i)+kldae(i+1))*(tr(i+1)-tr(i))
     arm   = arm + 0.5*(intar(i)+intar(i+1))*(tr(i+1)-tr(i))
    endif
  enddo
  print * ,' media gas transfer velocity nom  = ',kldm/(0.291-0.133)
  print * ,' media gas transfer velocity real = ',kldem/(0.291-0.133)
  print * ,' media area interface dimens      = ',arm/(0.291-0.133)
  print * ,' media area interface increase    = ',((arm/(0.291-0.133))-intaread(1))/intaread(1)*100

!
 else
!
  print * ,' non calcolo media gas transfer velocity '
!
 end if

  stop
 end program processo
