# time history della derivata dell'energia in acqua scalata per il valore iniziale
# riportata in funzione di t/Tp.
# 
# le curve sono plottate con la bezier per ridurre le oscillazioni. 
# vengono anche caricati a valori medi del dissipation rate per
# confronto
#
set xr [0:4.8]
set yr [-0.05:0.8]
set yl '{/Italic T}_{/Italic p }{/Italic /E}_{/Italic w0} {/Italic dE}_{/Italic w }{/Italic /dt}'
set xl '{/Italic t /T}_{/Italic p }'
#set grid
set lmargin 12
set rmargin 3.5
set tmargin 1
set bmargin 4.5
#set logscale y
set key top right
tp1=(0.04701*2.5066)
tp2=(0.07462*2.5066)
pl 'derivate-dim-025-10.dat' u ($1/(0.04701*2.5066)):(-$3/9.16701879E-07*tp1) t '0.25 - 1.e4' smooth bezier w l  linecolor 6 dt 4
repl 'diss-rate-med-025-10.dat' u ($1/(0.04701*2.5066)):($2/9.16701879E-07*tp1) every 2 t '' w lp linecolor 6 dt 4
repl 'derivate-dim-025-40.dat' u ($1/(0.07462*2.5066)):(-$3/3.69562113E-05*tp2) t '0.25 - 4.e4' smooth bezier w l linecolor 6
repl 'diss-rate-med-025-40.dat' u ($1/(0.07462*2.5066)):($2/3.69562113E-05*tp2) every 2 t '' w lp linecolor 6
repl 'derivate-dim-037-10.dat' u ($1/(0.04701*2.5066)):(-$3/2.19739377E-06*tp1) t '0.37 - 1.e4' smooth bezier w l linecolor 2 dt 4
repl 'diss-rate-med-037-10.dat' u ($1/(0.04701*2.5066)):($2/2.19739377E-06*tp1)  every 2 t '' w lp linecolor 2 dt 4
repl 'derivate-dim-037-40.dat' u ($1/(0.07462*2.5066)):(-$3/8.85950431E-05*tp2) t '0.37 - 4.e4' smooth bezier w l linecolor 2
repl 'diss-rate-med-037-40.dat' u ($1/(0.07462*2.5066)):($2/8.85950431E-05*tp2) every 2 t '' w lp linecolor 2
repl 'derivate-dim-050-10.dat' u ($1/(0.04701*2.5066)):(-$3/4.65990070E-06*tp1) t '0.50 - 1.e4' smooth bezier w l linecolor 7 dt 4
repl 'diss-rate-med-050-10.dat' u ($1/(0.04701*2.5066)):($2/4.65990070E-06*tp1) every 2 t '' w lp linecolor 7 dt 4
repl 'derivate-dim-050-40.dat' u ($1/(0.07462*2.5066)):(-$3/1.87923171E-04*tp2) t '0.50 - 4.e4' smooth bezier w l linecolor 7 
repl 'diss-rate-med-050-40.dat' u ($1/(0.07462*2.5066)):($2/1.87923171E-04*tp2) every 2 t '' w lp linecolor 7
set term post eps enhanced color linewidth 5.0 22
set out 'diss-aver-eps-rey.eps'
rep
