import argparse
parser = argparse.ArgumentParser(description='train_.')

parser.add_argument('--device', default='0', type=str)

parser.add_argument('--dataset', default='10', type=str)
args = parser.parse_args()

output_file = f"result_set_resnet18_{args.device}.txt"  
cmd_file= f"commands_kvsuk_{args.device}.txt"

with open(cmd_file, "w") as file:
    if args.device == "0":
        for b in [1,2,3,4,6,8,10]:
            command = f"python rec_mult.py --optim GIA-L  --num_images {b*4}  --gias --generative_model DCGAN --gen_dataset C10  --max_iterations 200  --dataset CIFAR10  --model  ResNet18 --target_id 0 --gias_iterations 7000  --gias_lr 0.00001 --device {args.device}  --bn 2e-4 --restarts 1 --tv 1e-4 --batch_size 4 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num {b*4}  --accumulation 1 --known"
            file.write(command+ f" >> {output_file}\n")
            command = f"python rec_mult.py --optim GIA-L  --num_images {b*4}  --gias --generative_model DCGAN --gen_dataset C10  --max_iterations 200  --dataset CIFAR10  --model  ResNet18 --target_id 0 --gias_iterations 7000  --gias_lr 0.00001 --device {args.device}  --bn 2e-4 --restarts 1 --tv 1e-4 --batch_size 4 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num {b*4}  --accumulation 1"
            file.write(command+ f" >> {output_file}\n")
            command = f"python rec_mult.py --optim GIA-L  --num_images {b*8}  --gias --generative_model DCGAN --gen_dataset C100  --max_iterations 200  --dataset CIFAR100  --model  ResNet18 --target_id 0 --gias_iterations 7000  --gias_lr 0.00001 --device {args.device}  --bn 2e-4 --restarts 1 --tv 1e-4 --batch_size 8 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num {b*8}  --accumulation 1 --known"
            file.write(command+ f" >> {output_file}\n")
            command = f"python rec_mult.py --optim GIA-L  --num_images {b*8}  --gias --generative_model DCGAN --gen_dataset C100  --max_iterations 200  --dataset CIFAR100  --model  ResNet18 --target_id 0 --gias_iterations 7000  --gias_lr 0.00001 --device {args.device}  --bn 2e-4 --restarts 1 --tv 1e-4 --batch_size 8 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num {b*8}  --accumulation 1"
            file.write(command+ f" >> {output_file}\n")
        for round in [1,2,4,6,8]:
            command = f"python rec_mult.py --optim GIA-L  --num_images 4  --gias --generative_model DCGAN --gen_dataset C10  --max_iterations 200  --dataset CIFAR10  --model  ResNet18 --target_id 0 --gias_iterations 7000  --gias_lr 0.00001 --device {args.device}  --bn 2e-4 --restarts 1 --tv 1e-4 --batch_size 4 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num 4  --accumulation {round}"
            file.write(command+ f" >> {output_file}\n")
            command = f"python rec_mult.py --optim GIA-L  --num_images 8  --gias --generative_model DCGAN --gen_dataset C100  --max_iterations 200  --dataset CIFAR100  --model  ResNet18 --target_id 0 --gias_iterations 7000  --gias_lr 0.00001 --device {args.device}  --bn 2e-4 --restarts 1 --tv 1e-4 --batch_size 8 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num 8  --accumulation {round}"
            file.write(command+ f" >> {output_file}\n")

    if args.device == "1":
        for b in [1,2,3,4,6,8,10]:
            command = f"python rec_mult.py --optim GIA-O  --num_images {b*4}   --max_iterations 7000 --accumulation 1  --dataset CIFAR10  --model  ResNet18 --target_i 0 --device {args.device}  --bn 1e-3  --batch_size 4 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num {b*4} --known"
            file.write(command+ f" >> {output_file}\n")
            command = f"python rec_mult.py --optim GIA-O  --num_images {b*4}   --max_iterations 7000 --accumulation 1  --dataset CIFAR10  --model  ResNet18 --target_i 0 --device {args.device}  --bn 1e-3  --batch_size 4 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num {b*4}"
            file.write(command+ f" >> {output_file}\n")
        for round in [1,2,4,6,8]:
            command = f"python rec_mult.py --optim GIA-O  --num_images 4   --max_iterations 7000 --accumulation {round}  --dataset CIFAR10  --model  ResNet18 --target_i 0 --device {args.device}  --bn 1e-3  --batch_size 4 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num 4"
            file.write(command+ f" >> {output_file}\n")
    elif args.device == "2":
        for b in [1,2,3,4,6,8,10]:
            command = f"python rec_mult.py --optim GIA-O  --num_images {b*8}   --max_iterations 7000 --accumulation 1  --dataset CIFAR100  --model  ResNet18 --target_i 0 --device {args.device}  --bn 1e-3  --batch_size 8 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num {b*8} --known"
            file.write(command+ f" >> {output_file}\n")
            command = f"python rec_mult.py --optim GIA-O  --num_images {b*8}   --max_iterations 7000 --accumulation 1  --dataset CIFAR100  --model  ResNet18 --target_i 0 --device {args.device}  --bn 1e-3  --batch_size 8 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num {b*8}"
            file.write(command+ f" >> {output_file}\n")
        for round in [1,2,4,6,8]:
            command = f"python rec_mult.py --optim GIA-O  --num_images 8   --max_iterations 7000 --accumulation {round}  --dataset CIFAR100  --model  ResNet18 --target_i 0 --device {args.device}  --bn 1e-3  --batch_size 8 --local_lr 0.1 --useFL --clients 1 --sample 1 --rounds 1 --vit_num 8"
            file.write(command+ f" >> {output_file}\n")

    
    else:
        print("Invalid GPU device. Please enter a device number between 0 and 7.")
import subprocess


with open(cmd_file, "r") as file:
    commands = file.readlines()
failed_commands = []  

for command in commands:
    command = command.strip()  
    print(f"Running command: {command}")
    try:
        subprocess.run(command, shell=True, check=True)
    except subprocess.CalledProcessError as e:
        print(f"Error occurred while executing the command: {command}")
        failed_commands.append(command)


if failed_commands:
    print("\nFailed commands:")
    for command in failed_commands:
        print(command)
