import argparse
parser = argparse.ArgumentParser(description='train_.')

parser.add_argument('--device', default='0', type=str)
parser.add_argument('--model', default='0', type=str)


args = parser.parse_args()
output_file = f"result_{args.model}_con_{args.device}.txt"  

''''''
with open(f"commands_{args.model}_con"+args.device+".txt", "w") as file:
    for id in []:
        for con in range(10):
            command = f"python rec_mult.py --optim GIA-O  --num_images 1   --max_iterations 3000  --dataset CIFAR10  --model  {args.model} --target_i {id} --device {args.device}  --config_id {con}"
            file.write(command+ f" >> {output_file}\n")
    
    


import subprocess

with open(f"commands_{args.model}_con"+args.device+".txt", "r") as file:
    commands = file.readlines()


failed_commands = [] 


for command in commands:
    command = command.strip()  
    print(f"Running command: {command}")
    try:
        subprocess.run(command, shell=True, check=True)
    except subprocess.CalledProcessError as e:
        print(f"Error occurred while executing the command: {command}")
        failed_commands.append(command)


if failed_commands:
    print("\nFailed commands:")
    for command in failed_commands:
        print(command)
