
import argparse
parser = argparse.ArgumentParser(description='train_.')

#For Fig.12, model == DenseNet43，DenseNet43_sht1，DenseNet43_sht2, DenseNet53，DenseNet53_sht1，DenseNet53_sht2

parser.add_argument('--device', default='0', type=str)
parser.add_argument('--model', default='0', type=str)


args = parser.parse_args()
output_file = f"result_{args.model}_{args.device}.txt"  

with open(f"commands_{args.model}_ood"+args.device+".txt", "w") as file:
    
    for id in []:
        if args.model=="SkipCNN-18":
            for skip in [-1,0,1,3,5,7]:
                command = f"python rec_mult.py --optim GIA-O  --num_images 1   --max_iterations 2000  --dataset CIFAR10  --model  {args.model} --target_i {id} --device {args.device}  --skip {skip}"
                file.write(command+ f" >> {output_file}\n")
        if args.model=="SkipCNN-34":
            for skip in [-1,0,1,2,4,5,6,8,9,10,11,12,14,15]:
                command = f"python rec_mult.py --optim GIA-O  --num_images 1   --max_iterations 2000  --dataset CIFAR10  --model  {args.model} --target_i {id} --device {args.device}  --skip {skip}"
                file.write(command+ f" >> {output_file}\n")


    
    


import subprocess


with open(f"commands_{args.model}_ood"+args.device+".txt", "r") as file:
    commands = file.readlines()


failed_commands = []  



for command in commands:
    command = command.strip()  
    print(f"Running command: {command}")
    try:
        subprocess.run(command, shell=True, check=True)
    except subprocess.CalledProcessError as e:
        print(f"Error occurred while executing the command: {command}")
        failed_commands.append(command)


if failed_commands:
    print("\nFailed commands:")
    for command in failed_commands:
        print(command)
