models0 =["Vgg11","Vgg16","Vgg19","ResNet18","ResNet50","ResNet152","DenseNet121","GoogleNet","Inception_v3"]
import torch
from torchvision import datasets, transforms
import random
random.seed(42)

transform = transforms.Compose([transforms.ToTensor()])

train_dataset = datasets.CIFAR10(root='~/data', train=True, download=True, transform=transform)


labels = train_dataset.targets


ids = []


for label in range(10):  
    label_indices = [i for i, lbl in enumerate(labels) if lbl == label]
    random_selected_indices = random.sample(label_indices, 5)  
    ids.extend(random_selected_indices)



pth_values = list(range(100))

import argparse
parser = argparse.ArgumentParser(description='train_.')

parser.add_argument('--device', default='0', type=str)


args = parser.parse_args()

if args.device=="0":
    models=models0
elif args.device=="1":
    models=models1
elif args.device=="2":
    models=models2
elif args.device=="3":
    models=models3
elif args.device=="4":
    models=models4
elif args.device=="5":
    models=models5


with open("commands_FL_audit"+args.device+".txt", "w") as file:

    for model in models:
        command = f"nohup python -u rec_mult_IGSA_fast.py --dataset CIFAR10 --model {model}  --device {args.device} > output_IGSA_{args.device}.txt 2>&1\n"
        file.write(command)



import subprocess


with open("commands_FL_audit"+args.device+".txt", "r") as file:
    commands = file.readlines()


failed_commands = []  



for command in commands:
    command = command.strip() 
    print(f"Running command: {command}")
    try:
        subprocess.run(command, shell=True, check=True)
    except subprocess.CalledProcessError as e:
        print(f"Error occurred while executing the command: {command}")
        failed_commands.append(command)


if failed_commands:
    print("\nFailed commands:")
    for command in failed_commands:
        print(command)
