'''
用来进行梯度剪裁、添加噪声、计算隐私预算
'''

import torch
import numpy as np
import random
import math
noise_scale = 0.0001
C = 1
std = noise_scale/C

def clipping(gradients, Fclip, clip_norm, layers):
    
    l2_norm = torch.norm(gradients)
    # print("l2_norm:", l2_norm)
    if Fclip == False:
        clip_norm = l2_norm
        clip_value = C/math.sqrt(layers)
    else:
        clip_value = C

    clipped_gradients = gradients / max(1, clip_norm / clip_value)
    return l2_norm, clipped_gradients

def adding_noise(gradients):
    GaussianNoises = torch.tensor(np.random.normal(loc=0.0, scale=float(C * std), size=gradients.shape),dtype = None,device=gradients.device)
    #print(len(gradients))
    gradients=gradients+GaussianNoises
    #print(gradients)
    return gradients
