import torch
import torch.nn as nn
import torchvision
#model = torchvision.models.googlenet(num_classes=10)
#model=torchvision.models.convnext_tiny(num_classes=10)
from cifar10_models.googlenet import googlenet
from cifar10_models.inception import inception_v3

model=googlenet(pretrained=False)
#model=inception_v3(pretrained=False)

''''''
# 示例神经网络模型
class MyModel(nn.Module):
    def __init__(self):
        super(MyModel, self).__init__()
        self.conv1 = nn.Conv2d(3, 64, kernel_size=3, padding=1)
        self.relu = nn.ReLU()
        self.fc1 = nn.Linear(64 * 32 * 32, 10)

    def forward(self, x):
        x = self.conv1(x)
        x = self.relu(x)
        x = x.view(x.size(0), -1)
        x = self.fc1(x)
        return x

# 创建模型实例
#model = MyModel()

print(model)
# 定义损失函数和优化器
criterion = nn.CrossEntropyLoss()
optimizer = torch.optim.SGD(model.parameters(), lr=0.01)

# 示例输入数据和标签
inputs = torch.randn(16, 3, 32, 32)
labels = torch.randint(10, (16,))

# 前向传播
outputs = model(inputs)
loss = criterion(outputs, labels)

total_params = 0
for param_name, param in model.named_parameters():
    if param.requires_grad:
        num_params = torch.prod(torch.tensor(param.size()))
        print(f'{param_name}: {num_params}')
        total_params += num_params

print(f'Total parameters: {total_params}')

# 反向传播计算梯度
loss.backward()
for mname, module in model.named_children():
    print(mname)
    for name, layer in module.named_children():
        if isinstance(layer, nn.Module):
            gradients = [p.grad for p in layer.parameters() if p.grad is not None]
            print(name,len(gradients))


# 获取模型中各个模块的梯度信息
#gradient_dict = {}
#for name, module in model.named_children():
#    if isinstance(module, nn.Module):
#        #print(len(module.parameters()))
#        gradients = [p.grad for p in module.parameters() if p.grad is not None]
#        print(name,len(gradients))
#        gradient_dict[name] = gradients

# 输出模型中各个模块的梯度信息
#print(gradient_dict)