import csv
import matplotlib.pyplot as plt
import numpy as np
import tikzplotlib

wgnum = 3


# Define the mapping between wgnum and wgexp
wgexp_dict = {1: 3, 2: 4, 3: 5, 4: 6, 5: 7, 6: 8, 7: 11, 8: 2, 9: 9, 10: 10}

# # Define the values of dp to be plotted
# dp_values = [0.2, 0.1]

# Define variables to store x and y values for each dp value
x_sph_dp1 = []
y_sph_dp1 = []
x_sph_dp2 = []
y_sph_dp2 = []
x_sph_dp3 = []
y_sph_dp3 = []
x_sph_dp4 = []
y_sph_dp4 = []
x_sph_dp5 = []
y_sph_dp5 = []

# Use the dictionary to get the corresponding wgexp value
wgexp = wgexp_dict[wgnum]

# SPH data (in meters)
with open('wg0.2.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    next(csvreader)  # skip first line
    next(csvreader)  # skip second line
    next(csvreader)  # skip third line
    next(csvreader)  # skip fourth line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_dp1.append(float(row[1]))
            y_sph_dp1.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters

# SPH data (in meters)
with open('wg0.1.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    next(csvreader)  # skip first line
    next(csvreader)  # skip second line
    next(csvreader)  # skip third line
    next(csvreader)  # skip fourth line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_dp2.append(float(row[1]))
            y_sph_dp2.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters

# SPH data (in meters)
with open('wg0.05.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    next(csvreader)  # skip first line
    next(csvreader)  # skip second line
    next(csvreader)  # skip third line
    next(csvreader)  # skip fourth line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_dp3.append(float(row[1]))
            y_sph_dp3.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters


# SPH data (in meters)
with open('wg0.025.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    next(csvreader)  # skip first line
    next(csvreader)  # skip second line
    next(csvreader)  # skip third line
    next(csvreader)  # skip fourth line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_dp4.append(float(row[1]))
            y_sph_dp4.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters
            
# SPH data (in meters)
with open('wg0.0125.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    next(csvreader)  # skip first line
    next(csvreader)  # skip second line
    next(csvreader)  # skip third line
    next(csvreader)  # skip fourth line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_dp5.append(float(row[1]))
            y_sph_dp5.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters


# Experimental data (in centimeters)
x_exp = []
y_exp = []
with open('wg'+str(wgnum)+'_exp.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    for row in csvreader:
        x_exp.append(float(row[0]))
        y_exp.append(float(row[1]))
x_exp, y_exp = zip(*sorted(zip(x_exp, y_exp)))

# VOF data (in centimeters)
x_vof = []
y_vof = []
with open('wg'+str(wgnum)+'_vof.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    for row in csvreader:
        x_vof.append(float(row[0]))
        y_vof.append(float(row[1]))
x_vof, y_vof = zip(*sorted(zip(x_vof, y_vof)))



# Define line styles and markers
line_styles = ['-', '--', '-.', ':', '-']
markers = ['o', 's', '^', '*', 'd']



# Plotting
# plt.plot(x_sph_dp1, y_sph_dp1, label='dp = 0.2', color='orange', linestyle=line_styles[0], linewidth=4)
plt.plot(x_sph_dp2, y_sph_dp2, label='dp = 0.1', color='green', linestyle='--', linewidth=4)
# plt.plot(x_sph_dp3, y_sph_dp3, label='dp = 0.05', color='green', linestyle='--', linewidth=4)
plt.plot(x_sph_dp4, y_sph_dp4, label='dp = 0.025', color='orange', linestyle='--', linewidth=4)
plt.plot(x_sph_dp5, y_sph_dp5, label='dp = 0.0125', color='red', linestyle='-', linewidth=4)
# plt.plot(x_vof, y_vof, label='VOF', color='green', linestyle='-.', linewidth=4)
plt.plot(x_exp, y_exp, label='Experiment', color='blue', linestyle=':', linewidth=4)


# Add labels, title, and legend
plt.xlabel('Time [s]')
plt.ylabel('Free surface elevation [cm]')
plt.ylim([-10, 50])
# plt.title('WG{}'.format(wgnum))
# plt.legend()

# Save the plot as a TikZ file
tikzplotlib.save('wg'+str(wgnum)+'c.tex')

# Display the plot
plt.show()





############# Legend plot ###########################