import tikzplotlib
import matplotlib.pyplot as plt

# Create a blank figure
fig, ax = plt.subplots()

# Hide the axis labels and ticks
ax.axis('off')

# Create empty plots with the desired labels, colors, linestyles, and linewidths
ax.plot([], [], label='dp = 0.1', color='green', linestyle='--', linewidth=4)
ax.plot([], [], label='dp = 0.025', color='orange', linestyle='--', linewidth=4)
ax.plot([], [], label='dp = 0.0125', color='red', linestyle='-', linewidth=4)
ax.plot([], [], label='Experiment', color='blue', linestyle=':', linewidth=4)

# Create the legend with a horizontal layout
legend = ax.legend(loc='center', ncol=4, bbox_to_anchor=(0.5, 0.5))

# Save the figure as a TeX file
tikzplotlib.save('wgc_legend.tex')

# Save the figure as an SVG file with tight bounding box
fig.savefig('wgc_legend.svg', format='svg', bbox_inches='tight', pad_inches=0)

# Save the figure as a PDF
fig.savefig('wgc_legend.pdf', format='pdf', bbox_inches='tight', pad_inches=0)


# Show the figure
plt.show()



