import csv
import matplotlib.pyplot as plt
import numpy as np

wgnum = 3

# Define the mapping between wgnum and wgexp
wgexp_dict = {1: 3, 2: 4, 3: 5, 4: 6, 5: 7, 6: 8, 7: 11, 8: 2, 9: 9, 10: 10}

# Define variables to store x and y values for each dp value
x_sph_dp1 = []
y_sph_dp1 = []
x_sph_dp2 = []
y_sph_dp2 = []
x_sph_dp3 = []
y_sph_dp3 = []
x_sph_dp4 = []
y_sph_dp4 = []
x_sph_dp5 = []
y_sph_dp5 = []

# Use the dictionary to get the corresponding wgexp value
wgexp = wgexp_dict[wgnum]

# SPH data (in meters)
with open('wg0.2.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    next(csvreader)  # skip first line
    next(csvreader)  # skip second line
    next(csvreader)  # skip third line
    next(csvreader)  # skip fourth line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_dp1.append(float(row[1]))
            y_sph_dp1.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters

# SPH data (in meters)
with open('wg0.1.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    next(csvreader)  # skip first line
    next(csvreader)  # skip second line
    next(csvreader)  # skip third line
    next(csvreader)  # skip fourth line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_dp2.append(float(row[1]))
            y_sph_dp2.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters

# SPH data (in meters)
with open('wg0.05.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    next(csvreader)  # skip first line
    next(csvreader)  # skip second line
    next(csvreader)  # skip third line
    next(csvreader)  # skip fourth line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_dp3.append(float(row[1]))
            y_sph_dp3.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters


# SPH data (in meters)
with open('wg0.025.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    next(csvreader)  # skip first line
    next(csvreader)  # skip second line
    next(csvreader)  # skip third line
    next(csvreader)  # skip fourth line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_dp4.append(float(row[1]))
            y_sph_dp4.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters
            
# SPH data (in meters)
with open('wg0.0125.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    next(csvreader)  # skip first line
    next(csvreader)  # skip second line
    next(csvreader)  # skip third line
    next(csvreader)  # skip fourth line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_dp5.append(float(row[1]))
            y_sph_dp5.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters


# Experimental data (in centimeters)
x_exp = []
y_exp = []
with open('wg'+str(wgnum)+'_exp.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=';')
    for row in csvreader:
        x_exp.append(float(row[0]))
        y_exp.append(float(row[1]))
x_exp, y_exp = zip(*sorted(zip(x_exp, y_exp)))

# Calculate the error in peak free surface elevation
error = ((max(y_exp) - max(y_sph_dp4))/max(y_exp))*100
print("Error in peak free surface elevation: {:.3f} %".format(error))


# Find the index of the maximum value in the experimental data
max_index_exp = y_exp.index(max(y_exp))
arrival_time_exp = x_exp[max_index_exp]

# Find the index of the maximum value in the SPH data (dp = 0.1)
max_index_sph = y_sph_dp4.index(max(y_sph_dp4))
arrival_time_sph = x_sph_dp4[max_index_sph]

# Calculate the arrival time error
arrival_time_error = ((arrival_time_exp - arrival_time_sph)/arrival_time_exp)*100
print("Arrival time error: {:.2f} %".format(arrival_time_error))
