import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import tikzplotlib

# Read the CSV file into a DataFrame
df = pd.read_csv('table.csv')

# Remove leading spaces from column names
df.columns = df.columns.str.strip()

# Scatter plot: 1-PFA-1-1 vs F
plt.scatter(df['1-PFA-1-1'], df['F'])
plt.xlabel('1-PFA-1-1')
plt.ylabel('F')
plt.title('1-PFA-1-1 vs F')

# Save the plot as a TikZ file
tikzplotlib.save('1pfa11vF.tex')

plt.show()

# Scatter plot: 1-PFA-1-1 vs K
plt.scatter(df['1-PFA-1-1'], df['K'])
plt.xlabel('1-PFA-1-1')
plt.ylabel('K')
plt.title('1-PFA-1-1 vs K')

# Save the plot as a TikZ file
tikzplotlib.save('1pfa11vK.tex')

plt.show()

# Scatter plot: 1-PFA-1-1 vs W
plt.scatter(df['1-PFA-1-1'], df['W'])
plt.xlabel('1-PFA-1-1')
plt.ylabel('W')
plt.title('1-PFA-1-1 vs W')

# Save the plot as a TikZ file
tikzplotlib.save('1pfa11vW.tex')

plt.show()


# Create a violin plot
plt.figure(figsize=(10, 6))
sns.violinplot(x='1-PFA-1-1', data=df)
plt.xlabel('Peak floor acceleration')
plt.ylabel('Storey')
plt.title('Violin Plot: 1-PFA-1-1')
plt.savefig('violin.png')

# Save the plot as a TikZ file
tikzplotlib.save('violin.tex')

plt.show()
