import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import tikzplotlib

# Read the CSV file into a DataFrame
df = pd.read_csv('table.csv')

# Remove leading spaces from column names
df.columns = df.columns.str.strip()

# Scatter plot: F vs 1-PFA-1-1 
plt.scatter(df['F'].div(1e6), df['1-PFA-1-1'].mul(1000))   # units TBC
plt.xlabel('Yield strength (MPa)')
plt.ylabel('Peak floor accelerations (mm/s$^2$)')
# plt.title('F vs 1-PFA-1-1')

# Save the plot as a TikZ file
tikzplotlib.save('1pfa11vF.tex')

plt.show()

# Scatter plot: K vs 1-PFA-1-1
plt.scatter(df['K'].div(1e6), df['1-PFA-1-1'].mul(1000))   # units TBC
plt.xlabel('Youngs modulus (MPa)')
plt.ylabel('Peak floor accelerations (mm/s$^2$)')
# plt.title('K vs 1-PFA-1-1')

# Save the plot as a TikZ file
tikzplotlib.save('1pfa11vK.tex')

plt.show()

# Scatter plot: W vs 1-PFA-1-1
plt.scatter(df['W'], df['1-PFA-1-1'].mul(1000))  
plt.xlabel('Floor weight (N)')      # units TBC
plt.ylabel('Peak floor accelerations (mm/s$^2$)')
# plt.title('W vs 1-PFA-1-1')

# Save the plot as a TikZ file
tikzplotlib.save('1pfa11vW.tex')

plt.show()



df['1-PFA-1-1'] = df['1-PFA-1-1'] * 1000 # Converted from m/s^2 to mm/s^2

# Calculate mean and standard deviation
mean = df['1-PFA-1-1'].mean()
std = df['1-PFA-1-1'].std()

# Print mean and standard deviation
print("Mean:", mean)
print("Standard Deviation:", std)




# Create a violin plot
plt.figure(figsize=(10, 6))
sns.violinplot(x='1-PFA-1-1', data=df)
plt.xlabel('Peak floor accelerations (mm/s$^2$)')
# plt.ylabel('Storey')
# plt.xlim(0, df['1-PFA-1-1'].max())  # Set x-axis limit to start from 0
plt.xlim(0, 2)  # Set x-axis limit to start from 0
# plt.title('Violin Plot: 1-PFA-1-1')
plt.savefig('violin.png')

# Save the plot as a PDF file
plt.savefig('violin.pdf')

plt.savefig('violin.svg')

# Save the plot as a TikZ file
tikzplotlib.save('violin.tex')

plt.show()


