import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import tikzplotlib

# distribution = "Lognormal"

# # Read the CSV file into a DataFrame
# df = pd.read_csv(f"{distribution}_dist_table.csv")

# # Remove leading spaces from column names
# df.columns = df.columns.str.strip()


# df['1-PFA-1-1'] = df['1-PFA-1-1'] * 1000 # Converted from m/s^2 to mm/s^2

# # Calculate mean and standard deviation
# mean = df['1-PFA-1-1'].mean()
# std = df['1-PFA-1-1'].std()

# # Print mean and standard deviation
# print("Mean:", mean)
# print("Standard Deviation:", std)


# # Create a violin plot
# plt.figure(figsize=(10, 6))
# sns.violinplot(x='1-PFA-1-1', data=df)
# plt.xlabel('Peak floor accelerations (mm/s$^2$)')
# # plt.ylabel('Storey')
# # plt.xlim(0, df['1-PFA-1-1'].max())  # Set x-axis limit to start from 0
# plt.xlim(0, 2)  # Set x-axis limit to start from 0
# # plt.title('Violin Plot: 1-PFA-1-1')
# plt.savefig(f"{distribution}_dist_violin.png")

# # Save the plot as a PDF file
# plt.savefig(f"{distribution}_dist_violin.pdf")

# plt.savefig(f"{distribution}_dist_violin.svg")

# # Save the plot as a TikZ file
# tikzplotlib.save(f"{distribution}_dist_violin.tex")

# plt.show()



############ Compare #################


# Assuming you have three distributions: "normal", "lognormal", and "other"
# Replace the following list with the actual distribution names if needed
distributions = ["Normal", "Lognormal", "Uniform"]

# Create an empty list to store all dataframes
dfs = []

# Read and process data for each distribution
for distribution in distributions:
    df = pd.read_csv(f"{distribution}_dist_table.csv")
    df.columns = df.columns.str.strip()
    df['1-PFA-1-1'] = df['1-PFA-1-1'] * 1000  # Converted from m/s^2 to mm/s^2
    df['Distribution'] = distribution  # Add a new column to identify the distribution
    dfs.append(df)

# Concatenate all dataframes into a single dataframe
df_all = pd.concat(dfs)

# Create a violin plot
plt.figure(figsize=(10, 6))
sns.violinplot(x='Distribution', y='1-PFA-1-1', data=df_all)
plt.xlabel('Distribution')
plt.ylabel('Peak floor accelerations (mm/s$^2$)')
plt.ylim(0, 2)  # Set y-axis limit
# plt.title('Violin Plot: 1-PFA-1-1')

# Save the plot as an image file
plt.savefig('all_distributions_violin.png')
plt.savefig('all_distributions_violin.pdf')
plt.savefig('all_distributions_violin.svg')

# Save the plot as a TikZ file
tikzplotlib.save('all_distributions_violin.tex')

plt.show()



