
import json
import numpy as np

################# MODIFY HERE ONLY ###################################
nfloors= 2
dt = 0.001
numSteps = 600 # Number of timesteps
Fx = np.ones((nfloors,numSteps))            #Replace these with time history
Fy = np.ones((nfloors,numSteps))*2
Tz = np.ones((nfloors,numSteps))*3
#######################################################################


evtInfo = {}

evtName = "myEvtTimeHist.json"
evtInfo["dT"] = dt
evtInfo["numSteps"] = numSteps

ndir = 3 # keep 3 if xyz
patterns = []
id_timeseries = 0
ts_dof_info = []
ts_floor_info = []
for nd in range(ndir):
    for nf in range(nfloors):
        id_timeseries +=1
        my_pattern = {}
        my_pattern["dof"]=nd+1
        my_pattern["floor"]=str(nf+1)
        my_pattern["name"]=str(id_timeseries)
        my_pattern["staticWindLoad"]=0.0
        my_pattern["timeSeries"]=str(id_timeseries)
        my_pattern["type"]="WindFloorLoad"
        patterns += [my_pattern]
        ts_dof_info += [nd]
        ts_floor_info += [nf]

evtInfo["pattern"] = patterns
evtInfo["subtype"] = "ExperimentalWindForces"
evtInfo["type"] = "Wind"


timeSeries = []
for id in range(id_timeseries):
    my_ts = {}
    my_ts["dT"]=dt
    my_ts["name"]=str(id+1)
    my_ts["type"]="Value"

    cur_dof = ts_dof_info[id]
    cur_floor = ts_floor_info[id]
    if cur_dof==0:
        my_ts["data"] = Fx[cur_floor , :].tolist()
    if cur_dof==1:
        my_ts["data"] = Fy[cur_floor , :].tolist()
    if cur_dof==2:
        my_ts["data"] = Tz[cur_floor , :].tolist()

    timeSeries += [my_ts]


evtInfo["timeSeries"] = timeSeries

with open(evtName, "w") as fp:
    json.dump({"Events":[evtInfo]} , fp) 
