import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import tikzplotlib

# Read the CSV file into a DataFrame
df = pd.read_csv('fsi3D_2story_2bay_60sample_fixed.csv')

# Remove leading spaces from column names
df.columns = df.columns.str.strip()


############################## RMSA #######################################

# Scatter plot: myFy vs RMSA_X
plt.scatter(df['myFy'], df['RMSA_X'])
plt.xlabel('Yield strength (MPa)')
plt.ylabel('Root mean square accelerations (m/s$^2$)')
#plt.title('myFy vs RMSA_X')

# Save the plot as a TikZ file
tikzplotlib.save('myfy_rmsa.tex')

# plt.show()

# Scatter plot: myQdl vs RMSA_X
plt.scatter(df['myQdl'], df['RMSA_X'])
plt.xlabel('W-section weight per length\nfor columns (N/m)')
plt.ylabel('Root mean square accelerations (m/s$^2$)')
#plt.title('myQdl vs RMSA_X')

# Save the plot as a TikZ file
tikzplotlib.save('myQdl_rmsa.tex')

# plt.show()

# Scatter plot: myQBeam vs RMSA_X
plt.scatter(df['myQBeam'], df['RMSA_X'])
plt.xlabel('W-section weight per length\nfor beams (N/m)')
plt.ylabel('Root mean square accelerations (m/s$^2$)')
#plt.title('myQBeam vs RMSA_X')

# Save the plot as a TikZ file
tikzplotlib.save('myQBeam_rmsa.tex')

# plt.show()


# Scatter plot: myQGrid vs RMSA_X
plt.scatter(df['myQGrid'], df['RMSA_X'])
plt.xlabel('W-section weight per length\nfor grid (N/m)')
plt.ylabel('Root mean square accelerations (m/s$^2$)')
#plt.title('myQGrid vs RMSA_X')

# Save the plot as a TikZ file
tikzplotlib.save('myQGrid_rmsa.tex')

# plt.show()


# Scatter plot: myEs vs RMSA_X
plt.scatter(df['myEs'], df['RMSA_X'])
plt.xlabel('Youngs modulus (MPa)')
plt.ylabel('Root mean square accelerations (m/s$^2$)')
#plt.title('myEs vs RMSA_X')

# Save the plot as a TikZ file
tikzplotlib.save('myEs_rmsa.tex')

# plt.show()


# Scatter plot: MultipleEvent vs RMSA_X
plt.scatter(df['MultipleEvent'], df['RMSA_X'])
plt.xlabel('Wave height (m)')
plt.ylabel('Root mean square accelerations (m/s$^2$)')
#plt.title('Wave height vs RMSA_X')

# Save the plot as a TikZ file
tikzplotlib.save('MultipleEvent_rmsa.tex')

# plt.show()


# Scatter plot: MultipleEvent vs RMSA_Y
plt.scatter(df['MultipleEvent'], df['RMSA_Y'])
plt.xlabel('Wave height (m)')
plt.ylabel('Root mean square accelerations\nin y-direction (m/s$^2$)')
#plt.title('Wave height vs RMSA_Y')

# Save the plot as a TikZ file
tikzplotlib.save('MultipleEvent_rmsa_y.tex')

# plt.show()

############################## PeakDisp #######################################

# Scatter plot: myFy vs PeakDisp_X
plt.scatter(df['myFy'], df['PeakDisp_X'])
plt.xlabel('Yield strength (MPa)')
plt.ylabel('Peak displacement in x-direction (m)')
#plt.title('myFy vs PeakDisp_X')

# Save the plot as a TikZ file
tikzplotlib.save('myfy_peakdisp.tex')

# plt.show()

# Scatter plot: myQdl vs PeakDisp_X
plt.scatter(df['myQdl'], df['PeakDisp_X'])
plt.xlabel('W-section weight per length\nfor columns (N/m)')
plt.ylabel('Peak displacement in x-direction (m)')
#plt.title('myQdl vs PeakDisp_X')

# Save the plot as a TikZ file
tikzplotlib.save('myQdl_peakdisp.tex')

# plt.show()

# Scatter plot: myQBeam vs PeakDisp_X
plt.scatter(df['myQBeam'], df['PeakDisp_X'])
plt.xlabel('W-section weight per length\nfor beams (N/m)')
plt.ylabel('Peak displacement in x-direction (m)')
#plt.title('myQBeam vs PeakDisp_X')

# Save the plot as a TikZ file
tikzplotlib.save('myQBeam_peakdisp.tex')

# plt.show()


# Scatter plot: myQGrid vs PeakDisp_X
plt.scatter(df['myQGrid'], df['PeakDisp_X'])
plt.xlabel('W-section weight per length\nfor grid (N/m)')
plt.ylabel('Peak displacement in x-direction (m)')
#plt.title('myQGrid vs PeakDisp_X')

# Save the plot as a TikZ file
tikzplotlib.save('myQGrid_peakdisp.tex')

# plt.show()


# Scatter plot: myEs vs PeakDisp_X
plt.scatter(df['myEs'], df['PeakDisp_X'])
plt.xlabel('Youngs modulus (MPa)')
plt.ylabel('Peak displacement in x-direction (m)')
#plt.title('myEs vs PeakDisp_X')

# Save the plot as a TikZ file
tikzplotlib.save('myEs_peakdisp.tex')

# plt.show()


# Scatter plot: MultipleEvent vs PeakDisp_X
plt.scatter(df['MultipleEvent'], df['PeakDisp_X'])
plt.xlabel('Wave height (m)')
plt.ylabel('Peak displacement in x-direction (m)')
#plt.title('Wave height vs PeakDisp_X')

# Save the plot as a TikZ file
tikzplotlib.save('MultipleEvent_peakdisp.tex')

# plt.show()


# Scatter plot: MultipleEvent vs PeakDisp_Y
plt.scatter(df['MultipleEvent'], df['PeakDisp_Y'])
plt.xlabel('Wave height (m)')
plt.ylabel('Peak displacement in y-direction (m)')
#plt.title('Wave height vs PeakDisp_Y')

# Save the plot as a TikZ file
tikzplotlib.save('MultipleEvent_peakdisp_y.tex')

# plt.show()



############################## Violin #######################################


############# PeakDisp ##############

# Calculate mean and standard deviation
mean_disp = df['PeakDisp_X'].mean()
std_disp = df['PeakDisp_X'].std()

# Print mean and standard deviation
print("Mean disp:", mean_disp)
print("Standard Deviation disp:", std_disp)


# Create a violin plot
plt.figure(figsize=(10, 6))
sns.violinplot(x='PeakDisp_X', data=df)
plt.xlabel('Peak displacement in x-direction (m)')
# plt.ylabel('Storey')
plt.xlim(0, 2e-6)  # Set x-axis limit to start from 0
#plt.title('Violin Plot: Peak displacement')
plt.savefig('violin_peak_displacement.png')

plt.savefig('violin_peak_displacement.pdf')
plt.savefig('violin_peak_displacement.svg')

# Save the plot as a TikZ file
tikzplotlib.save('violin_peak_displacement.tex')

plt.show()


############# RMSA ##############

# Calculate mean and standard deviation
mean_accl = df['RMSA_X'].mean()
std_accl = df['RMSA_X'].std()

# Print mean and standard deviation
print("Mean accl:", mean_accl)
print("Standard Deviation: accl", std_accl)


# Create a violin plot
plt.figure(figsize=(10, 6))
sns.violinplot(x='RMSA_X', data=df)
plt.xlabel('Root mean square accelerations\nin x-direction (m/s$^2$)')

plt.xlim(-0.5, 2.5)  # Set x-axis limit to start from 0
# plt.ylabel('Storey')
#plt.title('Violin Plot: Root mean square acceleration')
plt.savefig('violin_root_mean_square_acceleration.png')

plt.savefig('violin_root_mean_square_acceleration.pdf')
plt.savefig('violin_root_mean_square_acceleration.svg')

# Save the plot as a TikZ file
tikzplotlib.save('violin_root_mean_square_acceleration.tex')

plt.show()