# --------------------------------------------------------------------------------------------------
# LibUnits.tcl -- define system of units
#		MKS
#

# define UNITS ----------------------------------------------------------------------------
set m 1.0; 				# define basic units -- output units
set N 1.0; 				# define basic units -- output units
set s 1.0; 				# define basic units -- output units
set LunitTXT "m";			# define basic-unit text for output
set FunitTXT "N";			# define basic-unit text for output
set TunitTXT "s";			# define basic-unit text for output
set mm [expr 0.001*$m]; 		# define engineering units
set Pa [expr $N/pow($m,2)];
set MPa [expr $Pa*1e6];
set N [expr $Pa*$m*$m];		# newtons
set Npm3 [expr $N/pow($m,3)];		# kilograms per cubic meter
set Npm2 [expr $N/pow($m,2)];		# newtons per square meter
set m2 [expr $m*$m]; 		# meter^2
set m4 [expr $m*$m*$m*$m]; 		# meter^4
set cm [expr 0.01*$m];		# centimeter, needed for displacement input in MultipleSupport excitation
set PI [expr 2*asin(1.0)]; 		# define constants
set g [expr 9.81*$m/pow($s,2)]; 	# gravitational acceleration
set Ubig 1.0e10; 			# a really large number
set Usmall [expr 1/$Ubig]; 		# a really small number
