import pandas as pd
import matplotlib.pyplot as plt
import tikzplotlib

# Define the list of wave heights and corresponding filenames
wave_heights = ["40cm","50cm", "60cm", "70cm", "80cm", "90cm"]
filenames = ["Mk11_ForceBuilding_wh{}.csv".format(h) for h in wave_heights]

# Define the list of colors for the legends
legend_colors = ['blue', 'green', 'orange', 'purple', 'magenta', 'cyan']

# Create a figure and axes
fig, ax = plt.subplots()

# Iterate over each wave height and plot the data
for wh, filename, colors in zip(wave_heights, filenames, legend_colors):
    # Read the csv file into a pandas dataframe
    df = pd.read_csv(filename, delimiter=';')

    # Extract the columns you need
    time = df["Time [s]"].values
    force_x = df["ForceFluid.x [N]"].values
    
    # Find the indices for time >= 5s and time <= 12s
    start_idx = (time >= 5)
    end_idx = (time <= 12)

    # Plot the graph for the specified time range
    ax.plot(time[start_idx & end_idx], force_x[start_idx & end_idx], label="Wave height = {}".format(wh), color=colors)

# Set labels and title
ax.set_xlabel("Time [s]")
ax.set_ylabel("Drag force [N]")
# ax.set_title("Drag force vs Time")

# Add a legend
ax.legend(loc='upper center', bbox_to_anchor=(0.5, -0.2), ncol=3, frameon=False)

# Save the plot as a TikZ file
tikzplotlib.save('forces_wh.tex')

# Display the plot
plt.show()
