import pandas as pd
import matplotlib.pyplot as plt
import tikzplotlib


# Time axis 
# Read the csv file into a pandas dataframe
dfsph = pd.read_csv('sph_forces_time.csv', delimiter=';')
# Extract the columns you need
time = dfsph["Time [s]"].values

# Create an empty dictionary to store forces for each wave gauge file
forces_dict = {}

# Labels and colors for legend
wave_height_labels = ["40cm", "50cm", "60cm", "70cm", "80cm", "90cm"]
legend_colors = ['blue', 'green', 'purple', 'orange', 'magenta', 'cyan']

# Loop through each wave gauge file and calculate the forces
for i in range(4, 10):
    filename = f'waveGauge_1_wvG5_wv0{i}_newgaugedata_Elevation.csv'
    df = pd.read_csv(filename)
    A = 0.20
    gamma_w = 9800  # unit weight of water N/m3
    Cp = 1.6  # dynamic pressure coefficient
    ds = df['Elevation_6 [m]'] - 0.75  # stillwater depth

    Pmax = Cp * gamma_w * ds + 1.2 * gamma_w * ds
    F_asce = Pmax * A

    # Assuming time and F_asce are pandas Series
    time_array = time
    forces_dict[filename] = F_asce.to_numpy()  # Convert F_asce to a NumPy array


# Plot all forces in the same plot
plt.figure(figsize=(10, 6))
for i, (filename, forces) in enumerate(forces_dict.items()):
    plt.plot(time_array, forces, label=wave_height_labels[i], color=legend_colors[i])

plt.xlabel('Time [s]')
# plt.ylabel('Forces')

plt.xlim(5, 12)

# Add legend to the plot with a title
plt.legend(title='Wave')

# Add legend to the plot
plt.legend()

# Save the plot as a TikZ file
tikzplotlib.save('forces_asce.tex')

plt.show()
