import pandas as pd
import matplotlib.pyplot as plt
import tikzplotlib
import numpy as np

# Load the Excel file
def calculate_forces(wave_gauge_data, velocity_data, width):
    # Assign values to rho and g
    rho = 1000  # density 
    g = 9.8   # gravitational acceleration

    # rho * g * h * h * w 
    stat_max = (wave_gauge_data['Elevation_6 [m]']-0.75) * rho * g * (wave_gauge_data['Elevation_6 [m]']-0.75) * width

    # Multiply values in "Elevation_6 [m] or wg 6" column by rho and g
    # Equivalent point load =  1/2 * rho * g * h * h * w
    stat_distr = 0.5 * (wave_gauge_data['Elevation_6 [m]']-0.75) * rho * g * ((wave_gauge_data['Elevation_6 [m]']-0.75) * width)

    # Convert the result to a Python array
    F_stat_max = stat_max.to_numpy()
    F_stat_distr = stat_distr.to_numpy()

    # Load the CSV file using numpy
    data = np.genfromtxt(velocity_data, delimiter=';')

    # Assign values to rho, Cd, and A
    rho = 1000  # Example value, replace with your desired value
    Cd = 1.25   # Example value, replace with your desired value
    A = 0.20    # Example value, replace with your desired value

    # Extract the relevant data from the array
    heights = data[2, 2:].astype(float)
    vel_data = data[4:, 2:].astype(float)

    # Calculate the height range
    height_range = heights[-1] - heights[0]

    # Calculate the effective velocity
    effective_velocity = np.trapz(vel_data, x=heights, axis=1) / height_range

    # Calculate the squared average multiplied by the given factors
    F_dyn = 0.5 * rho * Cd * A * (effective_velocity ** 2)

    # Calculate total forces
    F_total_max = F_stat_max + F_dyn
    F_total_distr = F_stat_distr + F_dyn

    return F_total_distr


wave_gauge_files = ['waveGauge_1_wvG5_wv{:02d}_newgaugedata_Elevation.csv'.format(i) for i in range(4, 10)]
velocity_files = ['wv{:0.1f}_PointsVelocity_Vel.m.csv'.format(i/10) for i in range(4, 10)]
width = 0.4  # Replace with the actual width value

# Store forces and legends for each case in lists
forces_data = []
wave_heights = ["40cm", "50cm", "60cm", "70cm", "80cm", "90cm"]
legend_colors = ['blue', 'green', 'purple', 'orange', 'magenta', 'cyan']

for wave_gauge_file, velocity_file, wave_height, color in zip(wave_gauge_files, velocity_files, wave_heights, legend_colors):
    wave_gauge_data = pd.read_csv(wave_gauge_file)
    forces = calculate_forces(wave_gauge_data, velocity_file, width)
    forces_data.append((wave_height, color, forces))

# Plotting
plt.figure(figsize=(10, 6))
for wave_height, color, forces in forces_data:
    time = pd.read_csv('sph_forces_time.csv', delimiter=';')["Time [s]"].values
    plt.plot(time, forces, label=wave_height, color=color)

plt.xlim(5, 12)
plt.legend(title='Wave Height', loc='upper right')
plt.xlabel('Time [s]')
plt.ylabel('Forces')
# plt.title('Comparison of Forces for Different Wave Heights')
plt.savefig('forces_comparison.png')
# Save the plot as a TikZ file
tikzplotlib.save('forces_analytical.tex')
plt.show()
