# UQ-WSI: Single building in Kyoto Flume

1. [Folder information](#Folder-information)
2. [Requirement](#Requirement)
5. [Questions and user requests](#Questions-and-user-requests)
6. [Reference](#Reference)

## Folder information
This repository contains files related to the Kyoto wave flume case, including simulations and results. The folders available in this repository are as below and are available as separate zip files:
- Gencase_and_simulation: This folder contains input files for pre-processing and simulation, and job scripts for executing pre-processing and simulation in the High Performance Computing (HPC) environment.
    - Geometry_files: Configuration of the simulation, which includes basin and building.
    - Kyotosolitary_Def: Input files containing the various parameters and settings required for the simulation. The value after swh in each file name in the folder represents the water depth and the value after wh represents the wave height.
    - Kyotosolitary_Gencase: Job scripts for pre-processing simulations in HPC.  The value after swh in each file name in the folder represents the water depth and the value after wh represents the wave height.
    -  Kyotosolitary_Run: Job scripts for running simulations in HPC.  The value after swh in each file name in the folder represents the water depth and the value after wh represents the wave height.
    
- Results : This folder contains job scripts for executing post-processing in the HPC environment, and the obtained results.
    - Waveheight_10WGs: This folder contains job scripts, text files for executing post-processing of free surface elevations in the HPC environment, and the obtained results.
        - WaveGauge_locations: Text files to define the locations of the wave gauges. The value after wh represents the wave height (m).
        - Waveheight_scripts: Job scripts for executing post-processing of free surface elevations in HPC. The value after swh in each file name in the folder represents the water depth and the value after wv represents the wave height (m).
        - Waveheight_results: The obtained wave height results at all locations specified in [WaveGauge_locations](#WaveGauge_locations) in the simulation. The value after wh represents the wave height (m).
    - Force: This folder contains the job scripts for post-processing the wave loads exerted on the building in the HPC environment, and the obtained results.
        - Force_scripts: Job scripts for executing post-processing of the wave loads exerted on the building in HPC.  The value after swh in each file name in the folder represents the water depth and the value after wh represents the wave height (m).
        - Force_results: The obtained results of wave loads exerted on the building in the simulation. The value after swh in each file name in the folder represents the water depth and the value after wh represents the wave height (m).
    - Velocity: This folder contains job scripts, text files for executing post-processing of water wave velocities in the HPC environment, and the obtained results.
        - Velocity_locations: Text files to define the locations of the velocity measurement.
        - Velocity_scripts: Job scripts for executing post-processing of velocities in HPC. The value after swh in each file name in the folder represents the water depth and the value after wh represents the wave height.
        - Velocity_results: The obtained velocities results at all locations specified in [Velocity_locations](#Velocity_locations) in the simulation. The value '1' means aingle building, and the value showed after '1' represents the wave height (m).
          - Velocity_in_front_of_building: The velocities obtained in front of the building are used to calculate hydrostatic and hydrodynamic forces in analytical force analysis.
    
    - Plots: This folder contains the plots of figures relative to simulation used in paper.
    
- UQ: This folder contains input files for one story and two stories bilding case, and the obtained results.
    - UQ_inputs: This folder contains Tcl script file, and the input files in json format are provided, which is obtained based on the wave loads exerted on the building in the simulation.
      - Tcl_files: script file to process and record simulation results in tool command language.
      - Input_files: wave loads exerted on the building in the simulation's data in JavaScript Object Notation
    - UQ_results: The folder contains uncertainty quantification data analysed for one-story building and two-story building.

- Documentation: This folder contains images used in the README files related to this repository.

## Requirement
The following softwares are required to generate and use the user elements.
- [DualSPHysics v5.0](https://dual.sphysics.org/downloads) or later version [^1].
- [WE-UQ](https://www.designsafe-ci.org/data/browser/public/designsafe.storage.community//SimCenter/Software/WE_UQ) version 3.1.0 mac or windows version [^2].
- HPC (CPU and GPU).

## Questions and user requests

If you have any questions related to the repository or would like help to explore new applications and contribute to the repository, please contact us through email. You can find the contact information on our webpage at https://www.harishlab.com/contact

## Reference

[^1]: DualSPHysics. Title of the repository. Retrieved from https://github.com/DualSPHysics/DualSPHysics
[^2]: WE-UQ. WE-UQ Software. DesignSafe-CI. Retrieved from https://www.designsafe-ci.org/data/browser/public/designsafe.storage.community/SimCenter/Software/WE_UQ
[^3]: NHERI-SimCenter. WE-UQ Documentation: Usage. Retrieved from https://nheri-simcenter.github.io/WE-UQ-Documentation/common/user_manual/usage/desktop/usage.html 