import tikzplotlib
import matplotlib.pyplot as plt

# Create a blank figure
fig, ax = plt.subplots()

# Hide the axis labels and ticks
ax.axis('off')


ax.plot([], [], label='SPH', color='red', linestyle='-', linewidth=4)
ax.plot([], [], label='VOF', color='green', linestyle='-.', linewidth=4)
ax.plot([], [], label='Experiment', color='blue', linestyle=':', linewidth=4)

# Create the legend with a horizontal layout
legend = ax.legend(loc='center', ncol=4, bbox_to_anchor=(0.5, 0.5))

# Save the figure as a TeX file
tikzplotlib.save('wgv_legend.tex')

# Save the figure as an SVG file with tight bounding box
fig.savefig('wgv_legend.svg', format='svg', bbox_inches='tight', pad_inches=0)


# Save the figure as a PDF
fig.savefig('wgv_legend.pdf', format='pdf', bbox_inches='tight', pad_inches=0)


# Show the figure
plt.show()



