import csv
import matplotlib.pyplot as plt
import numpy as np
import tikzplotlib

wgnum = 10


# Define the mapping between wgnum and wgexp
wgexp_dict = {1: 3, 2: 4, 3: 5, 4: 6, 5: 7, 6: 8, 7: 11, 8: 2, 9: 9, 10: 10}


# Define variables to store x and y values for each wave height
x_sph_h4 = []
y_sph_h4 = []
x_sph_h5 = []
y_sph_h5 = []
x_sph_h6 = []
y_sph_h6 = []
x_sph_h7 = []
y_sph_h7 = []
x_sph_h8 = []
y_sph_h8 = []
x_sph_h9 = []
y_sph_h9 = []

# Use the dictionary to get the corresponding wgexp value
wgexp = wgexp_dict[wgnum]

# SPH data (in meters)
with open('waveGauge_1_wvG5_wv04_newgaugedata_Elevation.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=',')
    next(csvreader)  # skip first line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_h4.append(float(row[1]))
            y_sph_h4.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters

# SPH data (in meters)
with open('waveGauge_1_wvG5_wv05_newgaugedata_Elevation.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=',')
    next(csvreader)  # skip first line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_h5.append(float(row[1]))
            y_sph_h5.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters

# SPH data (in meters)
with open('waveGauge_1_wvG5_wv06_newgaugedata_Elevation.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=',')
    next(csvreader)  # skip first line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_h6.append(float(row[1]))
            y_sph_h6.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters


# SPH data (in meters)
with open('waveGauge_1_wvG5_wv07_newgaugedata_Elevation.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=',')
    next(csvreader)  # skip first line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_h7.append(float(row[1]))
            y_sph_h7.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters
            
# SPH data (in meters)
with open('waveGauge_1_wvG5_wv08_newgaugedata_Elevation.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=',')
    next(csvreader)  # skip first line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_h8.append(float(row[1]))
            y_sph_h8.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters
            

# SPH data (in meters)
with open('waveGauge_1_wvG5_wv09_newgaugedata_Elevation.csv', newline='') as csvfile:
    csvreader = csv.reader(csvfile, delimiter=',')
    next(csvreader)  # skip first line
    for row in csvreader:
        x_val = float(row[1])
        if x_val >= 2 and x_val <= 12:
            x_sph_h9.append(float(row[1]))
            y_sph_h9.append(float(row[wgexp]) * 100 - 75)  # convert from meters to centimeters



# Plotting
plt.plot(x_sph_h4, y_sph_h4, label='Wave height = 40cm', color='blue', linestyle='-', linewidth=2)
plt.plot(x_sph_h5, y_sph_h5, label='Wave height = 50cm', color='green', linestyle='-', linewidth=2)
plt.plot(x_sph_h6, y_sph_h6, label='Wave height = 60cm', color='orange', linestyle='-', linewidth=2)
plt.plot(x_sph_h7, y_sph_h7, label='Wave height = 70cm', color='purple', linestyle='-', linewidth=2)
plt.plot(x_sph_h8, y_sph_h8, label='Wave height = 80cm', color='magenta', linestyle='-', linewidth=2)
plt.plot(x_sph_h9, y_sph_h9, label='Wave height = 90cm', color='cyan', linestyle='-', linewidth=2)


# Add labels, title, and legend
plt.xlabel('Time [s]')
plt.ylabel('Free surface elevation [cm]')
# plt.title('WG{}'.format(wgnum))
# plt.legend()

# Save the plot as a TikZ file
tikzplotlib.save('wg'+str(wgnum)+'hn.tex')

# Display the plot
plt.show()



