import tikzplotlib
import matplotlib.pyplot as plt

# Create a blank figure
fig, ax = plt.subplots()

# Hide the axis labels and ticks
ax.axis('off')


# Plotting
ax.plot([], [], label='Wave height = 40cm', color='blue', linestyle='-', linewidth=2)
ax.plot([], [], label='Wave height = 50cm', color='green', linestyle='-', linewidth=2)
ax.plot([], [], label='Wave height = 60cm', color='orange', linestyle='-', linewidth=2)
ax.plot([], [], label='Wave height = 70cm', color='purple', linestyle='-', linewidth=2)
ax.plot([], [], label='Wave height = 80cm', color='magenta', linestyle='-', linewidth=2)
ax.plot([], [], label='Wave height = 90cm', color='cyan', linestyle='-', linewidth=2)


# Create the legend with a horizontal layout
legend = ax.legend(loc='center', ncol=3, bbox_to_anchor=(0.5, 0.5))

# Save the figure as a TeX file
tikzplotlib.save('wgc_legend.tex')

# Save the figure as an SVG file with tight bounding box
fig.savefig('wgh_legend.svg', format='svg', bbox_inches='tight', pad_inches=0)

# Save the figure as an pdf file with tight bounding box
fig.savefig('wgh_legend.pdf', format='pdf', bbox_inches='tight', pad_inches=0)

# Show the figure
plt.show()



