curr_dir=`realpath $(dirname $0)`
args=""
args+=" -L /share/qemu"
args+=" -machine q35,accel=kvm,kernel_irqchip=split"
args+=" -cpu host,-vmx-rdseed-exit,pmu=off,amx-tile=on"
args+=" -m 512G"
args+=" -smp 64"
args+=" -boot menu=on"
args+=" -bios ${curr_dir}/OVMF.fd"
args+=" -initrd ${curr_dir}/initrd.img-5.15.120+"
args+=" -kernel ${curr_dir}/vmlinuz-5.15.120+"
append="rootwait rootflags=data=ordered,errors=remount-ro rw root=/dev/vda1 rootfstype=ext4 console=ttyS0 console=tty0 tdx_disable_filter systemd.show_status=true systemd.log_level=debug net.ifnames=0"
args+=" -device virtio-blk-pci,drive=demo-image"
args+=" -drive id=demo-image,file=${curr_dir}/demo.image,format=raw,if=none"
args+=" -device virtio-blk-pci,drive=extra-image"
args+=" -drive id=extra-image,file=${curr_dir}/extra.image,format=raw,if=none"
args+=" -device vhost-vsock-pci,guest-cid=8022"
args+=" -object tdx-guest,sept-ve-disable=on,id=tdx,quote-generation-service=vsock:2:4050"
args+=" -object memory-backend-memfd-private,id=dimm1,size=256G"
args+=" -machine confidential-guest-support=tdx,memory-backend=dimm1"
args+=" -device virtio-net-pci,netdev=usernet0,mac=7a:ad:fd:3a:0c:d2"
args+=" -netdev user,id=usernet0"
args+=" -device virtio-net-pci,netdev=bridgenet0,mac=52:54:00:00:00:01"
args+=" -netdev bridge,id=bridgenet0,br=virbr0,helper=/usr/lib/qemu/qemu-bridge-helper"
args+=" -vga none"
args+=" -nographic"
args+=" -monitor pty"
args+=" -device virtio-serial-pci"
args+=" -chardev stdio,id=chardev0,mux=on,logfile=chardev.log"
args+=" -device virtconsole,chardev=chardev0"
args+=" -serial chardev:chardev0"
qemu-system-x86_64 ${args} -append "${append}"