/*
 * Copyright ConsenSys Software Inc., 2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package tech.pegasys.teku.statetransition.validation;

import java.util.Optional;
import tech.pegasys.teku.infrastructure.async.SafeFuture;
import tech.pegasys.teku.spec.datastructures.state.beaconstate.BeaconState;
import tech.pegasys.teku.spec.logic.common.operations.validation.OperationInvalidReason;
import tech.pegasys.teku.statetransition.OperationPool;

public interface OperationValidator<T> {

  /**
   * Validates an operation before adding it into an {@link OperationPool}. Used when receiving
   * operation messages broadcast via gossip or sent to the node's REST API.
   */
  SafeFuture<InternalValidationResult> validateForGossip(T operation);

  /**
   * * Validates an operation when selecting it from an {@link OperationPool}. Used when creating a
   * new block.
   */
  Optional<OperationInvalidReason> validateForBlockInclusion(
      BeaconState stateAtBlockSlot, T operation);
}
