// Code generated by fastssz. DO NOT EDIT.
// Hash: 9d3bf801facfb6d585fde0fadcdf8946a18bf44771c59db3e180da32a6dc313a
package v1

import (
	ssz "github.com/prysmaticlabs/fastssz"
	github_com_prysmaticlabs_prysm_v4_consensus_types_primitives "github.com/prysmaticlabs/prysm/v4/consensus-types/primitives"
)

// MarshalSSZ ssz marshals the Attestation object
func (a *Attestation) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(a)
}

// MarshalSSZTo ssz marshals the Attestation object to a target array
func (a *Attestation) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf
	offset := int(228)

	// Offset (0) 'AggregationBits'
	dst = ssz.WriteOffset(dst, offset)
	offset += len(a.AggregationBits)

	// Field (1) 'Data'
	if a.Data == nil {
		a.Data = new(AttestationData)
	}
	if dst, err = a.Data.MarshalSSZTo(dst); err != nil {
		return
	}

	// Field (2) 'Signature'
	if size := len(a.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	dst = append(dst, a.Signature...)

	// Field (0) 'AggregationBits'
	if size := len(a.AggregationBits); size > 2048 {
		err = ssz.ErrBytesLengthFn("--.AggregationBits", size, 2048)
		return
	}
	dst = append(dst, a.AggregationBits...)

	return
}

// UnmarshalSSZ ssz unmarshals the Attestation object
func (a *Attestation) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size < 228 {
		return ssz.ErrSize
	}

	tail := buf
	var o0 uint64

	// Offset (0) 'AggregationBits'
	if o0 = ssz.ReadOffset(buf[0:4]); o0 > size {
		return ssz.ErrOffset
	}

	if o0 < 228 {
		return ssz.ErrInvalidVariableOffset
	}

	// Field (1) 'Data'
	if a.Data == nil {
		a.Data = new(AttestationData)
	}
	if err = a.Data.UnmarshalSSZ(buf[4:132]); err != nil {
		return err
	}

	// Field (2) 'Signature'
	if cap(a.Signature) == 0 {
		a.Signature = make([]byte, 0, len(buf[132:228]))
	}
	a.Signature = append(a.Signature, buf[132:228]...)

	// Field (0) 'AggregationBits'
	{
		buf = tail[o0:]
		if err = ssz.ValidateBitlist(buf, 2048); err != nil {
			return err
		}
		if cap(a.AggregationBits) == 0 {
			a.AggregationBits = make([]byte, 0, len(buf))
		}
		a.AggregationBits = append(a.AggregationBits, buf...)
	}
	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the Attestation object
func (a *Attestation) SizeSSZ() (size int) {
	size = 228

	// Field (0) 'AggregationBits'
	size += len(a.AggregationBits)

	return
}

// HashTreeRoot ssz hashes the Attestation object
func (a *Attestation) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(a)
}

// HashTreeRootWith ssz hashes the Attestation object with a hasher
func (a *Attestation) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'AggregationBits'
	if len(a.AggregationBits) == 0 {
		err = ssz.ErrEmptyBitlist
		return
	}
	hh.PutBitlist(a.AggregationBits, 2048)

	// Field (1) 'Data'
	if err = a.Data.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (2) 'Signature'
	if size := len(a.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	hh.PutBytes(a.Signature)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the AggregateAttestationAndProof object
func (a *AggregateAttestationAndProof) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(a)
}

// MarshalSSZTo ssz marshals the AggregateAttestationAndProof object to a target array
func (a *AggregateAttestationAndProof) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf
	offset := int(108)

	// Field (0) 'AggregatorIndex'
	dst = ssz.MarshalUint64(dst, uint64(a.AggregatorIndex))

	// Offset (1) 'Aggregate'
	dst = ssz.WriteOffset(dst, offset)
	if a.Aggregate == nil {
		a.Aggregate = new(Attestation)
	}
	offset += a.Aggregate.SizeSSZ()

	// Field (2) 'SelectionProof'
	if size := len(a.SelectionProof); size != 96 {
		err = ssz.ErrBytesLengthFn("--.SelectionProof", size, 96)
		return
	}
	dst = append(dst, a.SelectionProof...)

	// Field (1) 'Aggregate'
	if dst, err = a.Aggregate.MarshalSSZTo(dst); err != nil {
		return
	}

	return
}

// UnmarshalSSZ ssz unmarshals the AggregateAttestationAndProof object
func (a *AggregateAttestationAndProof) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size < 108 {
		return ssz.ErrSize
	}

	tail := buf
	var o1 uint64

	// Field (0) 'AggregatorIndex'
	a.AggregatorIndex = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.ValidatorIndex(ssz.UnmarshallUint64(buf[0:8]))

	// Offset (1) 'Aggregate'
	if o1 = ssz.ReadOffset(buf[8:12]); o1 > size {
		return ssz.ErrOffset
	}

	if o1 < 108 {
		return ssz.ErrInvalidVariableOffset
	}

	// Field (2) 'SelectionProof'
	if cap(a.SelectionProof) == 0 {
		a.SelectionProof = make([]byte, 0, len(buf[12:108]))
	}
	a.SelectionProof = append(a.SelectionProof, buf[12:108]...)

	// Field (1) 'Aggregate'
	{
		buf = tail[o1:]
		if a.Aggregate == nil {
			a.Aggregate = new(Attestation)
		}
		if err = a.Aggregate.UnmarshalSSZ(buf); err != nil {
			return err
		}
	}
	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the AggregateAttestationAndProof object
func (a *AggregateAttestationAndProof) SizeSSZ() (size int) {
	size = 108

	// Field (1) 'Aggregate'
	if a.Aggregate == nil {
		a.Aggregate = new(Attestation)
	}
	size += a.Aggregate.SizeSSZ()

	return
}

// HashTreeRoot ssz hashes the AggregateAttestationAndProof object
func (a *AggregateAttestationAndProof) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(a)
}

// HashTreeRootWith ssz hashes the AggregateAttestationAndProof object with a hasher
func (a *AggregateAttestationAndProof) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'AggregatorIndex'
	hh.PutUint64(uint64(a.AggregatorIndex))

	// Field (1) 'Aggregate'
	if err = a.Aggregate.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (2) 'SelectionProof'
	if size := len(a.SelectionProof); size != 96 {
		err = ssz.ErrBytesLengthFn("--.SelectionProof", size, 96)
		return
	}
	hh.PutBytes(a.SelectionProof)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the SignedAggregateAttestationAndProof object
func (s *SignedAggregateAttestationAndProof) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(s)
}

// MarshalSSZTo ssz marshals the SignedAggregateAttestationAndProof object to a target array
func (s *SignedAggregateAttestationAndProof) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf
	offset := int(100)

	// Offset (0) 'Message'
	dst = ssz.WriteOffset(dst, offset)
	if s.Message == nil {
		s.Message = new(AggregateAttestationAndProof)
	}
	offset += s.Message.SizeSSZ()

	// Field (1) 'Signature'
	if size := len(s.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	dst = append(dst, s.Signature...)

	// Field (0) 'Message'
	if dst, err = s.Message.MarshalSSZTo(dst); err != nil {
		return
	}

	return
}

// UnmarshalSSZ ssz unmarshals the SignedAggregateAttestationAndProof object
func (s *SignedAggregateAttestationAndProof) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size < 100 {
		return ssz.ErrSize
	}

	tail := buf
	var o0 uint64

	// Offset (0) 'Message'
	if o0 = ssz.ReadOffset(buf[0:4]); o0 > size {
		return ssz.ErrOffset
	}

	if o0 < 100 {
		return ssz.ErrInvalidVariableOffset
	}

	// Field (1) 'Signature'
	if cap(s.Signature) == 0 {
		s.Signature = make([]byte, 0, len(buf[4:100]))
	}
	s.Signature = append(s.Signature, buf[4:100]...)

	// Field (0) 'Message'
	{
		buf = tail[o0:]
		if s.Message == nil {
			s.Message = new(AggregateAttestationAndProof)
		}
		if err = s.Message.UnmarshalSSZ(buf); err != nil {
			return err
		}
	}
	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the SignedAggregateAttestationAndProof object
func (s *SignedAggregateAttestationAndProof) SizeSSZ() (size int) {
	size = 100

	// Field (0) 'Message'
	if s.Message == nil {
		s.Message = new(AggregateAttestationAndProof)
	}
	size += s.Message.SizeSSZ()

	return
}

// HashTreeRoot ssz hashes the SignedAggregateAttestationAndProof object
func (s *SignedAggregateAttestationAndProof) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(s)
}

// HashTreeRootWith ssz hashes the SignedAggregateAttestationAndProof object with a hasher
func (s *SignedAggregateAttestationAndProof) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Message'
	if err = s.Message.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (1) 'Signature'
	if size := len(s.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	hh.PutBytes(s.Signature)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the AttestationData object
func (a *AttestationData) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(a)
}

// MarshalSSZTo ssz marshals the AttestationData object to a target array
func (a *AttestationData) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'Slot'
	dst = ssz.MarshalUint64(dst, uint64(a.Slot))

	// Field (1) 'Index'
	dst = ssz.MarshalUint64(dst, uint64(a.Index))

	// Field (2) 'BeaconBlockRoot'
	if size := len(a.BeaconBlockRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.BeaconBlockRoot", size, 32)
		return
	}
	dst = append(dst, a.BeaconBlockRoot...)

	// Field (3) 'Source'
	if a.Source == nil {
		a.Source = new(Checkpoint)
	}
	if dst, err = a.Source.MarshalSSZTo(dst); err != nil {
		return
	}

	// Field (4) 'Target'
	if a.Target == nil {
		a.Target = new(Checkpoint)
	}
	if dst, err = a.Target.MarshalSSZTo(dst); err != nil {
		return
	}

	return
}

// UnmarshalSSZ ssz unmarshals the AttestationData object
func (a *AttestationData) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 128 {
		return ssz.ErrSize
	}

	// Field (0) 'Slot'
	a.Slot = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.Slot(ssz.UnmarshallUint64(buf[0:8]))

	// Field (1) 'Index'
	a.Index = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.CommitteeIndex(ssz.UnmarshallUint64(buf[8:16]))

	// Field (2) 'BeaconBlockRoot'
	if cap(a.BeaconBlockRoot) == 0 {
		a.BeaconBlockRoot = make([]byte, 0, len(buf[16:48]))
	}
	a.BeaconBlockRoot = append(a.BeaconBlockRoot, buf[16:48]...)

	// Field (3) 'Source'
	if a.Source == nil {
		a.Source = new(Checkpoint)
	}
	if err = a.Source.UnmarshalSSZ(buf[48:88]); err != nil {
		return err
	}

	// Field (4) 'Target'
	if a.Target == nil {
		a.Target = new(Checkpoint)
	}
	if err = a.Target.UnmarshalSSZ(buf[88:128]); err != nil {
		return err
	}

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the AttestationData object
func (a *AttestationData) SizeSSZ() (size int) {
	size = 128
	return
}

// HashTreeRoot ssz hashes the AttestationData object
func (a *AttestationData) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(a)
}

// HashTreeRootWith ssz hashes the AttestationData object with a hasher
func (a *AttestationData) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Slot'
	hh.PutUint64(uint64(a.Slot))

	// Field (1) 'Index'
	hh.PutUint64(uint64(a.Index))

	// Field (2) 'BeaconBlockRoot'
	if size := len(a.BeaconBlockRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.BeaconBlockRoot", size, 32)
		return
	}
	hh.PutBytes(a.BeaconBlockRoot)

	// Field (3) 'Source'
	if err = a.Source.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (4) 'Target'
	if err = a.Target.HashTreeRootWith(hh); err != nil {
		return
	}

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the Checkpoint object
func (c *Checkpoint) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(c)
}

// MarshalSSZTo ssz marshals the Checkpoint object to a target array
func (c *Checkpoint) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'Epoch'
	dst = ssz.MarshalUint64(dst, uint64(c.Epoch))

	// Field (1) 'Root'
	if size := len(c.Root); size != 32 {
		err = ssz.ErrBytesLengthFn("--.Root", size, 32)
		return
	}
	dst = append(dst, c.Root...)

	return
}

// UnmarshalSSZ ssz unmarshals the Checkpoint object
func (c *Checkpoint) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 40 {
		return ssz.ErrSize
	}

	// Field (0) 'Epoch'
	c.Epoch = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.Epoch(ssz.UnmarshallUint64(buf[0:8]))

	// Field (1) 'Root'
	if cap(c.Root) == 0 {
		c.Root = make([]byte, 0, len(buf[8:40]))
	}
	c.Root = append(c.Root, buf[8:40]...)

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the Checkpoint object
func (c *Checkpoint) SizeSSZ() (size int) {
	size = 40
	return
}

// HashTreeRoot ssz hashes the Checkpoint object
func (c *Checkpoint) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(c)
}

// HashTreeRootWith ssz hashes the Checkpoint object with a hasher
func (c *Checkpoint) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Epoch'
	hh.PutUint64(uint64(c.Epoch))

	// Field (1) 'Root'
	if size := len(c.Root); size != 32 {
		err = ssz.ErrBytesLengthFn("--.Root", size, 32)
		return
	}
	hh.PutBytes(c.Root)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the BeaconBlock object
func (b *BeaconBlock) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(b)
}

// MarshalSSZTo ssz marshals the BeaconBlock object to a target array
func (b *BeaconBlock) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf
	offset := int(84)

	// Field (0) 'Slot'
	dst = ssz.MarshalUint64(dst, uint64(b.Slot))

	// Field (1) 'ProposerIndex'
	dst = ssz.MarshalUint64(dst, uint64(b.ProposerIndex))

	// Field (2) 'ParentRoot'
	if size := len(b.ParentRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.ParentRoot", size, 32)
		return
	}
	dst = append(dst, b.ParentRoot...)

	// Field (3) 'StateRoot'
	if size := len(b.StateRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.StateRoot", size, 32)
		return
	}
	dst = append(dst, b.StateRoot...)

	// Offset (4) 'Body'
	dst = ssz.WriteOffset(dst, offset)
	if b.Body == nil {
		b.Body = new(BeaconBlockBody)
	}
	offset += b.Body.SizeSSZ()

	// Field (4) 'Body'
	if dst, err = b.Body.MarshalSSZTo(dst); err != nil {
		return
	}

	return
}

// UnmarshalSSZ ssz unmarshals the BeaconBlock object
func (b *BeaconBlock) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size < 84 {
		return ssz.ErrSize
	}

	tail := buf
	var o4 uint64

	// Field (0) 'Slot'
	b.Slot = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.Slot(ssz.UnmarshallUint64(buf[0:8]))

	// Field (1) 'ProposerIndex'
	b.ProposerIndex = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.ValidatorIndex(ssz.UnmarshallUint64(buf[8:16]))

	// Field (2) 'ParentRoot'
	if cap(b.ParentRoot) == 0 {
		b.ParentRoot = make([]byte, 0, len(buf[16:48]))
	}
	b.ParentRoot = append(b.ParentRoot, buf[16:48]...)

	// Field (3) 'StateRoot'
	if cap(b.StateRoot) == 0 {
		b.StateRoot = make([]byte, 0, len(buf[48:80]))
	}
	b.StateRoot = append(b.StateRoot, buf[48:80]...)

	// Offset (4) 'Body'
	if o4 = ssz.ReadOffset(buf[80:84]); o4 > size {
		return ssz.ErrOffset
	}

	if o4 < 84 {
		return ssz.ErrInvalidVariableOffset
	}

	// Field (4) 'Body'
	{
		buf = tail[o4:]
		if b.Body == nil {
			b.Body = new(BeaconBlockBody)
		}
		if err = b.Body.UnmarshalSSZ(buf); err != nil {
			return err
		}
	}
	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the BeaconBlock object
func (b *BeaconBlock) SizeSSZ() (size int) {
	size = 84

	// Field (4) 'Body'
	if b.Body == nil {
		b.Body = new(BeaconBlockBody)
	}
	size += b.Body.SizeSSZ()

	return
}

// HashTreeRoot ssz hashes the BeaconBlock object
func (b *BeaconBlock) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(b)
}

// HashTreeRootWith ssz hashes the BeaconBlock object with a hasher
func (b *BeaconBlock) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Slot'
	hh.PutUint64(uint64(b.Slot))

	// Field (1) 'ProposerIndex'
	hh.PutUint64(uint64(b.ProposerIndex))

	// Field (2) 'ParentRoot'
	if size := len(b.ParentRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.ParentRoot", size, 32)
		return
	}
	hh.PutBytes(b.ParentRoot)

	// Field (3) 'StateRoot'
	if size := len(b.StateRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.StateRoot", size, 32)
		return
	}
	hh.PutBytes(b.StateRoot)

	// Field (4) 'Body'
	if err = b.Body.HashTreeRootWith(hh); err != nil {
		return
	}

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the SignedBeaconBlock object
func (s *SignedBeaconBlock) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(s)
}

// MarshalSSZTo ssz marshals the SignedBeaconBlock object to a target array
func (s *SignedBeaconBlock) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf
	offset := int(100)

	// Offset (0) 'Block'
	dst = ssz.WriteOffset(dst, offset)
	if s.Block == nil {
		s.Block = new(BeaconBlock)
	}
	offset += s.Block.SizeSSZ()

	// Field (1) 'Signature'
	if size := len(s.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	dst = append(dst, s.Signature...)

	// Field (0) 'Block'
	if dst, err = s.Block.MarshalSSZTo(dst); err != nil {
		return
	}

	return
}

// UnmarshalSSZ ssz unmarshals the SignedBeaconBlock object
func (s *SignedBeaconBlock) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size < 100 {
		return ssz.ErrSize
	}

	tail := buf
	var o0 uint64

	// Offset (0) 'Block'
	if o0 = ssz.ReadOffset(buf[0:4]); o0 > size {
		return ssz.ErrOffset
	}

	if o0 < 100 {
		return ssz.ErrInvalidVariableOffset
	}

	// Field (1) 'Signature'
	if cap(s.Signature) == 0 {
		s.Signature = make([]byte, 0, len(buf[4:100]))
	}
	s.Signature = append(s.Signature, buf[4:100]...)

	// Field (0) 'Block'
	{
		buf = tail[o0:]
		if s.Block == nil {
			s.Block = new(BeaconBlock)
		}
		if err = s.Block.UnmarshalSSZ(buf); err != nil {
			return err
		}
	}
	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the SignedBeaconBlock object
func (s *SignedBeaconBlock) SizeSSZ() (size int) {
	size = 100

	// Field (0) 'Block'
	if s.Block == nil {
		s.Block = new(BeaconBlock)
	}
	size += s.Block.SizeSSZ()

	return
}

// HashTreeRoot ssz hashes the SignedBeaconBlock object
func (s *SignedBeaconBlock) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(s)
}

// HashTreeRootWith ssz hashes the SignedBeaconBlock object with a hasher
func (s *SignedBeaconBlock) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Block'
	if err = s.Block.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (1) 'Signature'
	if size := len(s.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	hh.PutBytes(s.Signature)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the BeaconBlockBody object
func (b *BeaconBlockBody) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(b)
}

// MarshalSSZTo ssz marshals the BeaconBlockBody object to a target array
func (b *BeaconBlockBody) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf
	offset := int(220)

	// Field (0) 'RandaoReveal'
	if size := len(b.RandaoReveal); size != 96 {
		err = ssz.ErrBytesLengthFn("--.RandaoReveal", size, 96)
		return
	}
	dst = append(dst, b.RandaoReveal...)

	// Field (1) 'Eth1Data'
	if b.Eth1Data == nil {
		b.Eth1Data = new(Eth1Data)
	}
	if dst, err = b.Eth1Data.MarshalSSZTo(dst); err != nil {
		return
	}

	// Field (2) 'Graffiti'
	if size := len(b.Graffiti); size != 32 {
		err = ssz.ErrBytesLengthFn("--.Graffiti", size, 32)
		return
	}
	dst = append(dst, b.Graffiti...)

	// Offset (3) 'ProposerSlashings'
	dst = ssz.WriteOffset(dst, offset)
	offset += len(b.ProposerSlashings) * 416

	// Offset (4) 'AttesterSlashings'
	dst = ssz.WriteOffset(dst, offset)
	for ii := 0; ii < len(b.AttesterSlashings); ii++ {
		offset += 4
		offset += b.AttesterSlashings[ii].SizeSSZ()
	}

	// Offset (5) 'Attestations'
	dst = ssz.WriteOffset(dst, offset)
	for ii := 0; ii < len(b.Attestations); ii++ {
		offset += 4
		offset += b.Attestations[ii].SizeSSZ()
	}

	// Offset (6) 'Deposits'
	dst = ssz.WriteOffset(dst, offset)
	offset += len(b.Deposits) * 1240

	// Offset (7) 'VoluntaryExits'
	dst = ssz.WriteOffset(dst, offset)
	offset += len(b.VoluntaryExits) * 112

	// Field (3) 'ProposerSlashings'
	if size := len(b.ProposerSlashings); size > 16 {
		err = ssz.ErrListTooBigFn("--.ProposerSlashings", size, 16)
		return
	}
	for ii := 0; ii < len(b.ProposerSlashings); ii++ {
		if dst, err = b.ProposerSlashings[ii].MarshalSSZTo(dst); err != nil {
			return
		}
	}

	// Field (4) 'AttesterSlashings'
	if size := len(b.AttesterSlashings); size > 2 {
		err = ssz.ErrListTooBigFn("--.AttesterSlashings", size, 2)
		return
	}
	{
		offset = 4 * len(b.AttesterSlashings)
		for ii := 0; ii < len(b.AttesterSlashings); ii++ {
			dst = ssz.WriteOffset(dst, offset)
			offset += b.AttesterSlashings[ii].SizeSSZ()
		}
	}
	for ii := 0; ii < len(b.AttesterSlashings); ii++ {
		if dst, err = b.AttesterSlashings[ii].MarshalSSZTo(dst); err != nil {
			return
		}
	}

	// Field (5) 'Attestations'
	if size := len(b.Attestations); size > 128 {
		err = ssz.ErrListTooBigFn("--.Attestations", size, 128)
		return
	}
	{
		offset = 4 * len(b.Attestations)
		for ii := 0; ii < len(b.Attestations); ii++ {
			dst = ssz.WriteOffset(dst, offset)
			offset += b.Attestations[ii].SizeSSZ()
		}
	}
	for ii := 0; ii < len(b.Attestations); ii++ {
		if dst, err = b.Attestations[ii].MarshalSSZTo(dst); err != nil {
			return
		}
	}

	// Field (6) 'Deposits'
	if size := len(b.Deposits); size > 16 {
		err = ssz.ErrListTooBigFn("--.Deposits", size, 16)
		return
	}
	for ii := 0; ii < len(b.Deposits); ii++ {
		if dst, err = b.Deposits[ii].MarshalSSZTo(dst); err != nil {
			return
		}
	}

	// Field (7) 'VoluntaryExits'
	if size := len(b.VoluntaryExits); size > 16 {
		err = ssz.ErrListTooBigFn("--.VoluntaryExits", size, 16)
		return
	}
	for ii := 0; ii < len(b.VoluntaryExits); ii++ {
		if dst, err = b.VoluntaryExits[ii].MarshalSSZTo(dst); err != nil {
			return
		}
	}

	return
}

// UnmarshalSSZ ssz unmarshals the BeaconBlockBody object
func (b *BeaconBlockBody) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size < 220 {
		return ssz.ErrSize
	}

	tail := buf
	var o3, o4, o5, o6, o7 uint64

	// Field (0) 'RandaoReveal'
	if cap(b.RandaoReveal) == 0 {
		b.RandaoReveal = make([]byte, 0, len(buf[0:96]))
	}
	b.RandaoReveal = append(b.RandaoReveal, buf[0:96]...)

	// Field (1) 'Eth1Data'
	if b.Eth1Data == nil {
		b.Eth1Data = new(Eth1Data)
	}
	if err = b.Eth1Data.UnmarshalSSZ(buf[96:168]); err != nil {
		return err
	}

	// Field (2) 'Graffiti'
	if cap(b.Graffiti) == 0 {
		b.Graffiti = make([]byte, 0, len(buf[168:200]))
	}
	b.Graffiti = append(b.Graffiti, buf[168:200]...)

	// Offset (3) 'ProposerSlashings'
	if o3 = ssz.ReadOffset(buf[200:204]); o3 > size {
		return ssz.ErrOffset
	}

	if o3 < 220 {
		return ssz.ErrInvalidVariableOffset
	}

	// Offset (4) 'AttesterSlashings'
	if o4 = ssz.ReadOffset(buf[204:208]); o4 > size || o3 > o4 {
		return ssz.ErrOffset
	}

	// Offset (5) 'Attestations'
	if o5 = ssz.ReadOffset(buf[208:212]); o5 > size || o4 > o5 {
		return ssz.ErrOffset
	}

	// Offset (6) 'Deposits'
	if o6 = ssz.ReadOffset(buf[212:216]); o6 > size || o5 > o6 {
		return ssz.ErrOffset
	}

	// Offset (7) 'VoluntaryExits'
	if o7 = ssz.ReadOffset(buf[216:220]); o7 > size || o6 > o7 {
		return ssz.ErrOffset
	}

	// Field (3) 'ProposerSlashings'
	{
		buf = tail[o3:o4]
		num, err := ssz.DivideInt2(len(buf), 416, 16)
		if err != nil {
			return err
		}
		b.ProposerSlashings = make([]*ProposerSlashing, num)
		for ii := 0; ii < num; ii++ {
			if b.ProposerSlashings[ii] == nil {
				b.ProposerSlashings[ii] = new(ProposerSlashing)
			}
			if err = b.ProposerSlashings[ii].UnmarshalSSZ(buf[ii*416 : (ii+1)*416]); err != nil {
				return err
			}
		}
	}

	// Field (4) 'AttesterSlashings'
	{
		buf = tail[o4:o5]
		num, err := ssz.DecodeDynamicLength(buf, 2)
		if err != nil {
			return err
		}
		b.AttesterSlashings = make([]*AttesterSlashing, num)
		err = ssz.UnmarshalDynamic(buf, num, func(indx int, buf []byte) (err error) {
			if b.AttesterSlashings[indx] == nil {
				b.AttesterSlashings[indx] = new(AttesterSlashing)
			}
			if err = b.AttesterSlashings[indx].UnmarshalSSZ(buf); err != nil {
				return err
			}
			return nil
		})
		if err != nil {
			return err
		}
	}

	// Field (5) 'Attestations'
	{
		buf = tail[o5:o6]
		num, err := ssz.DecodeDynamicLength(buf, 128)
		if err != nil {
			return err
		}
		b.Attestations = make([]*Attestation, num)
		err = ssz.UnmarshalDynamic(buf, num, func(indx int, buf []byte) (err error) {
			if b.Attestations[indx] == nil {
				b.Attestations[indx] = new(Attestation)
			}
			if err = b.Attestations[indx].UnmarshalSSZ(buf); err != nil {
				return err
			}
			return nil
		})
		if err != nil {
			return err
		}
	}

	// Field (6) 'Deposits'
	{
		buf = tail[o6:o7]
		num, err := ssz.DivideInt2(len(buf), 1240, 16)
		if err != nil {
			return err
		}
		b.Deposits = make([]*Deposit, num)
		for ii := 0; ii < num; ii++ {
			if b.Deposits[ii] == nil {
				b.Deposits[ii] = new(Deposit)
			}
			if err = b.Deposits[ii].UnmarshalSSZ(buf[ii*1240 : (ii+1)*1240]); err != nil {
				return err
			}
		}
	}

	// Field (7) 'VoluntaryExits'
	{
		buf = tail[o7:]
		num, err := ssz.DivideInt2(len(buf), 112, 16)
		if err != nil {
			return err
		}
		b.VoluntaryExits = make([]*SignedVoluntaryExit, num)
		for ii := 0; ii < num; ii++ {
			if b.VoluntaryExits[ii] == nil {
				b.VoluntaryExits[ii] = new(SignedVoluntaryExit)
			}
			if err = b.VoluntaryExits[ii].UnmarshalSSZ(buf[ii*112 : (ii+1)*112]); err != nil {
				return err
			}
		}
	}
	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the BeaconBlockBody object
func (b *BeaconBlockBody) SizeSSZ() (size int) {
	size = 220

	// Field (3) 'ProposerSlashings'
	size += len(b.ProposerSlashings) * 416

	// Field (4) 'AttesterSlashings'
	for ii := 0; ii < len(b.AttesterSlashings); ii++ {
		size += 4
		size += b.AttesterSlashings[ii].SizeSSZ()
	}

	// Field (5) 'Attestations'
	for ii := 0; ii < len(b.Attestations); ii++ {
		size += 4
		size += b.Attestations[ii].SizeSSZ()
	}

	// Field (6) 'Deposits'
	size += len(b.Deposits) * 1240

	// Field (7) 'VoluntaryExits'
	size += len(b.VoluntaryExits) * 112

	return
}

// HashTreeRoot ssz hashes the BeaconBlockBody object
func (b *BeaconBlockBody) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(b)
}

// HashTreeRootWith ssz hashes the BeaconBlockBody object with a hasher
func (b *BeaconBlockBody) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'RandaoReveal'
	if size := len(b.RandaoReveal); size != 96 {
		err = ssz.ErrBytesLengthFn("--.RandaoReveal", size, 96)
		return
	}
	hh.PutBytes(b.RandaoReveal)

	// Field (1) 'Eth1Data'
	if err = b.Eth1Data.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (2) 'Graffiti'
	if size := len(b.Graffiti); size != 32 {
		err = ssz.ErrBytesLengthFn("--.Graffiti", size, 32)
		return
	}
	hh.PutBytes(b.Graffiti)

	// Field (3) 'ProposerSlashings'
	{
		subIndx := hh.Index()
		num := uint64(len(b.ProposerSlashings))
		if num > 16 {
			err = ssz.ErrIncorrectListSize
			return
		}
		for _, elem := range b.ProposerSlashings {
			if err = elem.HashTreeRootWith(hh); err != nil {
				return
			}
		}
		if ssz.EnableVectorizedHTR {
			hh.MerkleizeWithMixinVectorizedHTR(subIndx, num, 16)
		} else {
			hh.MerkleizeWithMixin(subIndx, num, 16)
		}
	}

	// Field (4) 'AttesterSlashings'
	{
		subIndx := hh.Index()
		num := uint64(len(b.AttesterSlashings))
		if num > 2 {
			err = ssz.ErrIncorrectListSize
			return
		}
		for _, elem := range b.AttesterSlashings {
			if err = elem.HashTreeRootWith(hh); err != nil {
				return
			}
		}
		if ssz.EnableVectorizedHTR {
			hh.MerkleizeWithMixinVectorizedHTR(subIndx, num, 2)
		} else {
			hh.MerkleizeWithMixin(subIndx, num, 2)
		}
	}

	// Field (5) 'Attestations'
	{
		subIndx := hh.Index()
		num := uint64(len(b.Attestations))
		if num > 128 {
			err = ssz.ErrIncorrectListSize
			return
		}
		for _, elem := range b.Attestations {
			if err = elem.HashTreeRootWith(hh); err != nil {
				return
			}
		}
		if ssz.EnableVectorizedHTR {
			hh.MerkleizeWithMixinVectorizedHTR(subIndx, num, 128)
		} else {
			hh.MerkleizeWithMixin(subIndx, num, 128)
		}
	}

	// Field (6) 'Deposits'
	{
		subIndx := hh.Index()
		num := uint64(len(b.Deposits))
		if num > 16 {
			err = ssz.ErrIncorrectListSize
			return
		}
		for _, elem := range b.Deposits {
			if err = elem.HashTreeRootWith(hh); err != nil {
				return
			}
		}
		if ssz.EnableVectorizedHTR {
			hh.MerkleizeWithMixinVectorizedHTR(subIndx, num, 16)
		} else {
			hh.MerkleizeWithMixin(subIndx, num, 16)
		}
	}

	// Field (7) 'VoluntaryExits'
	{
		subIndx := hh.Index()
		num := uint64(len(b.VoluntaryExits))
		if num > 16 {
			err = ssz.ErrIncorrectListSize
			return
		}
		for _, elem := range b.VoluntaryExits {
			if err = elem.HashTreeRootWith(hh); err != nil {
				return
			}
		}
		if ssz.EnableVectorizedHTR {
			hh.MerkleizeWithMixinVectorizedHTR(subIndx, num, 16)
		} else {
			hh.MerkleizeWithMixin(subIndx, num, 16)
		}
	}

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the ProposerSlashing object
func (p *ProposerSlashing) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(p)
}

// MarshalSSZTo ssz marshals the ProposerSlashing object to a target array
func (p *ProposerSlashing) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'SignedHeader_1'
	if p.SignedHeader_1 == nil {
		p.SignedHeader_1 = new(SignedBeaconBlockHeader)
	}
	if dst, err = p.SignedHeader_1.MarshalSSZTo(dst); err != nil {
		return
	}

	// Field (1) 'SignedHeader_2'
	if p.SignedHeader_2 == nil {
		p.SignedHeader_2 = new(SignedBeaconBlockHeader)
	}
	if dst, err = p.SignedHeader_2.MarshalSSZTo(dst); err != nil {
		return
	}

	return
}

// UnmarshalSSZ ssz unmarshals the ProposerSlashing object
func (p *ProposerSlashing) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 416 {
		return ssz.ErrSize
	}

	// Field (0) 'SignedHeader_1'
	if p.SignedHeader_1 == nil {
		p.SignedHeader_1 = new(SignedBeaconBlockHeader)
	}
	if err = p.SignedHeader_1.UnmarshalSSZ(buf[0:208]); err != nil {
		return err
	}

	// Field (1) 'SignedHeader_2'
	if p.SignedHeader_2 == nil {
		p.SignedHeader_2 = new(SignedBeaconBlockHeader)
	}
	if err = p.SignedHeader_2.UnmarshalSSZ(buf[208:416]); err != nil {
		return err
	}

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the ProposerSlashing object
func (p *ProposerSlashing) SizeSSZ() (size int) {
	size = 416
	return
}

// HashTreeRoot ssz hashes the ProposerSlashing object
func (p *ProposerSlashing) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(p)
}

// HashTreeRootWith ssz hashes the ProposerSlashing object with a hasher
func (p *ProposerSlashing) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'SignedHeader_1'
	if err = p.SignedHeader_1.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (1) 'SignedHeader_2'
	if err = p.SignedHeader_2.HashTreeRootWith(hh); err != nil {
		return
	}

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the AttesterSlashing object
func (a *AttesterSlashing) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(a)
}

// MarshalSSZTo ssz marshals the AttesterSlashing object to a target array
func (a *AttesterSlashing) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf
	offset := int(8)

	// Offset (0) 'Attestation_1'
	dst = ssz.WriteOffset(dst, offset)
	if a.Attestation_1 == nil {
		a.Attestation_1 = new(IndexedAttestation)
	}
	offset += a.Attestation_1.SizeSSZ()

	// Offset (1) 'Attestation_2'
	dst = ssz.WriteOffset(dst, offset)
	if a.Attestation_2 == nil {
		a.Attestation_2 = new(IndexedAttestation)
	}
	offset += a.Attestation_2.SizeSSZ()

	// Field (0) 'Attestation_1'
	if dst, err = a.Attestation_1.MarshalSSZTo(dst); err != nil {
		return
	}

	// Field (1) 'Attestation_2'
	if dst, err = a.Attestation_2.MarshalSSZTo(dst); err != nil {
		return
	}

	return
}

// UnmarshalSSZ ssz unmarshals the AttesterSlashing object
func (a *AttesterSlashing) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size < 8 {
		return ssz.ErrSize
	}

	tail := buf
	var o0, o1 uint64

	// Offset (0) 'Attestation_1'
	if o0 = ssz.ReadOffset(buf[0:4]); o0 > size {
		return ssz.ErrOffset
	}

	if o0 < 8 {
		return ssz.ErrInvalidVariableOffset
	}

	// Offset (1) 'Attestation_2'
	if o1 = ssz.ReadOffset(buf[4:8]); o1 > size || o0 > o1 {
		return ssz.ErrOffset
	}

	// Field (0) 'Attestation_1'
	{
		buf = tail[o0:o1]
		if a.Attestation_1 == nil {
			a.Attestation_1 = new(IndexedAttestation)
		}
		if err = a.Attestation_1.UnmarshalSSZ(buf); err != nil {
			return err
		}
	}

	// Field (1) 'Attestation_2'
	{
		buf = tail[o1:]
		if a.Attestation_2 == nil {
			a.Attestation_2 = new(IndexedAttestation)
		}
		if err = a.Attestation_2.UnmarshalSSZ(buf); err != nil {
			return err
		}
	}
	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the AttesterSlashing object
func (a *AttesterSlashing) SizeSSZ() (size int) {
	size = 8

	// Field (0) 'Attestation_1'
	if a.Attestation_1 == nil {
		a.Attestation_1 = new(IndexedAttestation)
	}
	size += a.Attestation_1.SizeSSZ()

	// Field (1) 'Attestation_2'
	if a.Attestation_2 == nil {
		a.Attestation_2 = new(IndexedAttestation)
	}
	size += a.Attestation_2.SizeSSZ()

	return
}

// HashTreeRoot ssz hashes the AttesterSlashing object
func (a *AttesterSlashing) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(a)
}

// HashTreeRootWith ssz hashes the AttesterSlashing object with a hasher
func (a *AttesterSlashing) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Attestation_1'
	if err = a.Attestation_1.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (1) 'Attestation_2'
	if err = a.Attestation_2.HashTreeRootWith(hh); err != nil {
		return
	}

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the Deposit object
func (d *Deposit) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(d)
}

// MarshalSSZTo ssz marshals the Deposit object to a target array
func (d *Deposit) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'Proof'
	if size := len(d.Proof); size != 33 {
		err = ssz.ErrVectorLengthFn("--.Proof", size, 33)
		return
	}
	for ii := 0; ii < 33; ii++ {
		if size := len(d.Proof[ii]); size != 32 {
			err = ssz.ErrBytesLengthFn("--.Proof[ii]", size, 32)
			return
		}
		dst = append(dst, d.Proof[ii]...)
	}

	// Field (1) 'Data'
	if d.Data == nil {
		d.Data = new(Deposit_Data)
	}
	if dst, err = d.Data.MarshalSSZTo(dst); err != nil {
		return
	}

	return
}

// UnmarshalSSZ ssz unmarshals the Deposit object
func (d *Deposit) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 1240 {
		return ssz.ErrSize
	}

	// Field (0) 'Proof'
	d.Proof = make([][]byte, 33)
	for ii := 0; ii < 33; ii++ {
		if cap(d.Proof[ii]) == 0 {
			d.Proof[ii] = make([]byte, 0, len(buf[0:1056][ii*32:(ii+1)*32]))
		}
		d.Proof[ii] = append(d.Proof[ii], buf[0:1056][ii*32:(ii+1)*32]...)
	}

	// Field (1) 'Data'
	if d.Data == nil {
		d.Data = new(Deposit_Data)
	}
	if err = d.Data.UnmarshalSSZ(buf[1056:1240]); err != nil {
		return err
	}

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the Deposit object
func (d *Deposit) SizeSSZ() (size int) {
	size = 1240
	return
}

// HashTreeRoot ssz hashes the Deposit object
func (d *Deposit) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(d)
}

// HashTreeRootWith ssz hashes the Deposit object with a hasher
func (d *Deposit) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Proof'
	{
		if size := len(d.Proof); size != 33 {
			err = ssz.ErrVectorLengthFn("--.Proof", size, 33)
			return
		}
		subIndx := hh.Index()
		for _, i := range d.Proof {
			if len(i) != 32 {
				err = ssz.ErrBytesLength
				return
			}
			hh.Append(i)
		}

		if ssz.EnableVectorizedHTR {
			hh.MerkleizeVectorizedHTR(subIndx)
		} else {
			hh.Merkleize(subIndx)
		}
	}

	// Field (1) 'Data'
	if err = d.Data.HashTreeRootWith(hh); err != nil {
		return
	}

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the VoluntaryExit object
func (v *VoluntaryExit) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(v)
}

// MarshalSSZTo ssz marshals the VoluntaryExit object to a target array
func (v *VoluntaryExit) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'Epoch'
	dst = ssz.MarshalUint64(dst, uint64(v.Epoch))

	// Field (1) 'ValidatorIndex'
	dst = ssz.MarshalUint64(dst, uint64(v.ValidatorIndex))

	return
}

// UnmarshalSSZ ssz unmarshals the VoluntaryExit object
func (v *VoluntaryExit) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 16 {
		return ssz.ErrSize
	}

	// Field (0) 'Epoch'
	v.Epoch = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.Epoch(ssz.UnmarshallUint64(buf[0:8]))

	// Field (1) 'ValidatorIndex'
	v.ValidatorIndex = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.ValidatorIndex(ssz.UnmarshallUint64(buf[8:16]))

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the VoluntaryExit object
func (v *VoluntaryExit) SizeSSZ() (size int) {
	size = 16
	return
}

// HashTreeRoot ssz hashes the VoluntaryExit object
func (v *VoluntaryExit) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(v)
}

// HashTreeRootWith ssz hashes the VoluntaryExit object with a hasher
func (v *VoluntaryExit) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Epoch'
	hh.PutUint64(uint64(v.Epoch))

	// Field (1) 'ValidatorIndex'
	hh.PutUint64(uint64(v.ValidatorIndex))

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the SignedVoluntaryExit object
func (s *SignedVoluntaryExit) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(s)
}

// MarshalSSZTo ssz marshals the SignedVoluntaryExit object to a target array
func (s *SignedVoluntaryExit) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'Message'
	if s.Message == nil {
		s.Message = new(VoluntaryExit)
	}
	if dst, err = s.Message.MarshalSSZTo(dst); err != nil {
		return
	}

	// Field (1) 'Signature'
	if size := len(s.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	dst = append(dst, s.Signature...)

	return
}

// UnmarshalSSZ ssz unmarshals the SignedVoluntaryExit object
func (s *SignedVoluntaryExit) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 112 {
		return ssz.ErrSize
	}

	// Field (0) 'Message'
	if s.Message == nil {
		s.Message = new(VoluntaryExit)
	}
	if err = s.Message.UnmarshalSSZ(buf[0:16]); err != nil {
		return err
	}

	// Field (1) 'Signature'
	if cap(s.Signature) == 0 {
		s.Signature = make([]byte, 0, len(buf[16:112]))
	}
	s.Signature = append(s.Signature, buf[16:112]...)

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the SignedVoluntaryExit object
func (s *SignedVoluntaryExit) SizeSSZ() (size int) {
	size = 112
	return
}

// HashTreeRoot ssz hashes the SignedVoluntaryExit object
func (s *SignedVoluntaryExit) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(s)
}

// HashTreeRootWith ssz hashes the SignedVoluntaryExit object with a hasher
func (s *SignedVoluntaryExit) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Message'
	if err = s.Message.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (1) 'Signature'
	if size := len(s.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	hh.PutBytes(s.Signature)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the Eth1Data object
func (e *Eth1Data) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(e)
}

// MarshalSSZTo ssz marshals the Eth1Data object to a target array
func (e *Eth1Data) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'DepositRoot'
	if size := len(e.DepositRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.DepositRoot", size, 32)
		return
	}
	dst = append(dst, e.DepositRoot...)

	// Field (1) 'DepositCount'
	dst = ssz.MarshalUint64(dst, e.DepositCount)

	// Field (2) 'BlockHash'
	if size := len(e.BlockHash); size != 32 {
		err = ssz.ErrBytesLengthFn("--.BlockHash", size, 32)
		return
	}
	dst = append(dst, e.BlockHash...)

	return
}

// UnmarshalSSZ ssz unmarshals the Eth1Data object
func (e *Eth1Data) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 72 {
		return ssz.ErrSize
	}

	// Field (0) 'DepositRoot'
	if cap(e.DepositRoot) == 0 {
		e.DepositRoot = make([]byte, 0, len(buf[0:32]))
	}
	e.DepositRoot = append(e.DepositRoot, buf[0:32]...)

	// Field (1) 'DepositCount'
	e.DepositCount = ssz.UnmarshallUint64(buf[32:40])

	// Field (2) 'BlockHash'
	if cap(e.BlockHash) == 0 {
		e.BlockHash = make([]byte, 0, len(buf[40:72]))
	}
	e.BlockHash = append(e.BlockHash, buf[40:72]...)

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the Eth1Data object
func (e *Eth1Data) SizeSSZ() (size int) {
	size = 72
	return
}

// HashTreeRoot ssz hashes the Eth1Data object
func (e *Eth1Data) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(e)
}

// HashTreeRootWith ssz hashes the Eth1Data object with a hasher
func (e *Eth1Data) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'DepositRoot'
	if size := len(e.DepositRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.DepositRoot", size, 32)
		return
	}
	hh.PutBytes(e.DepositRoot)

	// Field (1) 'DepositCount'
	hh.PutUint64(e.DepositCount)

	// Field (2) 'BlockHash'
	if size := len(e.BlockHash); size != 32 {
		err = ssz.ErrBytesLengthFn("--.BlockHash", size, 32)
		return
	}
	hh.PutBytes(e.BlockHash)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the BeaconBlockHeader object
func (b *BeaconBlockHeader) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(b)
}

// MarshalSSZTo ssz marshals the BeaconBlockHeader object to a target array
func (b *BeaconBlockHeader) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'Slot'
	dst = ssz.MarshalUint64(dst, uint64(b.Slot))

	// Field (1) 'ProposerIndex'
	dst = ssz.MarshalUint64(dst, uint64(b.ProposerIndex))

	// Field (2) 'ParentRoot'
	if size := len(b.ParentRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.ParentRoot", size, 32)
		return
	}
	dst = append(dst, b.ParentRoot...)

	// Field (3) 'StateRoot'
	if size := len(b.StateRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.StateRoot", size, 32)
		return
	}
	dst = append(dst, b.StateRoot...)

	// Field (4) 'BodyRoot'
	if size := len(b.BodyRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.BodyRoot", size, 32)
		return
	}
	dst = append(dst, b.BodyRoot...)

	return
}

// UnmarshalSSZ ssz unmarshals the BeaconBlockHeader object
func (b *BeaconBlockHeader) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 112 {
		return ssz.ErrSize
	}

	// Field (0) 'Slot'
	b.Slot = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.Slot(ssz.UnmarshallUint64(buf[0:8]))

	// Field (1) 'ProposerIndex'
	b.ProposerIndex = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.ValidatorIndex(ssz.UnmarshallUint64(buf[8:16]))

	// Field (2) 'ParentRoot'
	if cap(b.ParentRoot) == 0 {
		b.ParentRoot = make([]byte, 0, len(buf[16:48]))
	}
	b.ParentRoot = append(b.ParentRoot, buf[16:48]...)

	// Field (3) 'StateRoot'
	if cap(b.StateRoot) == 0 {
		b.StateRoot = make([]byte, 0, len(buf[48:80]))
	}
	b.StateRoot = append(b.StateRoot, buf[48:80]...)

	// Field (4) 'BodyRoot'
	if cap(b.BodyRoot) == 0 {
		b.BodyRoot = make([]byte, 0, len(buf[80:112]))
	}
	b.BodyRoot = append(b.BodyRoot, buf[80:112]...)

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the BeaconBlockHeader object
func (b *BeaconBlockHeader) SizeSSZ() (size int) {
	size = 112
	return
}

// HashTreeRoot ssz hashes the BeaconBlockHeader object
func (b *BeaconBlockHeader) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(b)
}

// HashTreeRootWith ssz hashes the BeaconBlockHeader object with a hasher
func (b *BeaconBlockHeader) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Slot'
	hh.PutUint64(uint64(b.Slot))

	// Field (1) 'ProposerIndex'
	hh.PutUint64(uint64(b.ProposerIndex))

	// Field (2) 'ParentRoot'
	if size := len(b.ParentRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.ParentRoot", size, 32)
		return
	}
	hh.PutBytes(b.ParentRoot)

	// Field (3) 'StateRoot'
	if size := len(b.StateRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.StateRoot", size, 32)
		return
	}
	hh.PutBytes(b.StateRoot)

	// Field (4) 'BodyRoot'
	if size := len(b.BodyRoot); size != 32 {
		err = ssz.ErrBytesLengthFn("--.BodyRoot", size, 32)
		return
	}
	hh.PutBytes(b.BodyRoot)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the SignedBeaconBlockHeader object
func (s *SignedBeaconBlockHeader) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(s)
}

// MarshalSSZTo ssz marshals the SignedBeaconBlockHeader object to a target array
func (s *SignedBeaconBlockHeader) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'Message'
	if s.Message == nil {
		s.Message = new(BeaconBlockHeader)
	}
	if dst, err = s.Message.MarshalSSZTo(dst); err != nil {
		return
	}

	// Field (1) 'Signature'
	if size := len(s.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	dst = append(dst, s.Signature...)

	return
}

// UnmarshalSSZ ssz unmarshals the SignedBeaconBlockHeader object
func (s *SignedBeaconBlockHeader) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 208 {
		return ssz.ErrSize
	}

	// Field (0) 'Message'
	if s.Message == nil {
		s.Message = new(BeaconBlockHeader)
	}
	if err = s.Message.UnmarshalSSZ(buf[0:112]); err != nil {
		return err
	}

	// Field (1) 'Signature'
	if cap(s.Signature) == 0 {
		s.Signature = make([]byte, 0, len(buf[112:208]))
	}
	s.Signature = append(s.Signature, buf[112:208]...)

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the SignedBeaconBlockHeader object
func (s *SignedBeaconBlockHeader) SizeSSZ() (size int) {
	size = 208
	return
}

// HashTreeRoot ssz hashes the SignedBeaconBlockHeader object
func (s *SignedBeaconBlockHeader) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(s)
}

// HashTreeRootWith ssz hashes the SignedBeaconBlockHeader object with a hasher
func (s *SignedBeaconBlockHeader) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Message'
	if err = s.Message.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (1) 'Signature'
	if size := len(s.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	hh.PutBytes(s.Signature)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the IndexedAttestation object
func (i *IndexedAttestation) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(i)
}

// MarshalSSZTo ssz marshals the IndexedAttestation object to a target array
func (i *IndexedAttestation) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf
	offset := int(228)

	// Offset (0) 'AttestingIndices'
	dst = ssz.WriteOffset(dst, offset)
	offset += len(i.AttestingIndices) * 8

	// Field (1) 'Data'
	if i.Data == nil {
		i.Data = new(AttestationData)
	}
	if dst, err = i.Data.MarshalSSZTo(dst); err != nil {
		return
	}

	// Field (2) 'Signature'
	if size := len(i.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	dst = append(dst, i.Signature...)

	// Field (0) 'AttestingIndices'
	if size := len(i.AttestingIndices); size > 2048 {
		err = ssz.ErrListTooBigFn("--.AttestingIndices", size, 2048)
		return
	}
	for ii := 0; ii < len(i.AttestingIndices); ii++ {
		dst = ssz.MarshalUint64(dst, i.AttestingIndices[ii])
	}

	return
}

// UnmarshalSSZ ssz unmarshals the IndexedAttestation object
func (i *IndexedAttestation) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size < 228 {
		return ssz.ErrSize
	}

	tail := buf
	var o0 uint64

	// Offset (0) 'AttestingIndices'
	if o0 = ssz.ReadOffset(buf[0:4]); o0 > size {
		return ssz.ErrOffset
	}

	if o0 < 228 {
		return ssz.ErrInvalidVariableOffset
	}

	// Field (1) 'Data'
	if i.Data == nil {
		i.Data = new(AttestationData)
	}
	if err = i.Data.UnmarshalSSZ(buf[4:132]); err != nil {
		return err
	}

	// Field (2) 'Signature'
	if cap(i.Signature) == 0 {
		i.Signature = make([]byte, 0, len(buf[132:228]))
	}
	i.Signature = append(i.Signature, buf[132:228]...)

	// Field (0) 'AttestingIndices'
	{
		buf = tail[o0:]
		num, err := ssz.DivideInt2(len(buf), 8, 2048)
		if err != nil {
			return err
		}
		i.AttestingIndices = ssz.ExtendUint64(i.AttestingIndices, num)
		for ii := 0; ii < num; ii++ {
			i.AttestingIndices[ii] = ssz.UnmarshallUint64(buf[ii*8 : (ii+1)*8])
		}
	}
	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the IndexedAttestation object
func (i *IndexedAttestation) SizeSSZ() (size int) {
	size = 228

	// Field (0) 'AttestingIndices'
	size += len(i.AttestingIndices) * 8

	return
}

// HashTreeRoot ssz hashes the IndexedAttestation object
func (i *IndexedAttestation) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(i)
}

// HashTreeRootWith ssz hashes the IndexedAttestation object with a hasher
func (i *IndexedAttestation) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'AttestingIndices'
	{
		if size := len(i.AttestingIndices); size > 2048 {
			err = ssz.ErrListTooBigFn("--.AttestingIndices", size, 2048)
			return
		}
		subIndx := hh.Index()
		for _, i := range i.AttestingIndices {
			hh.AppendUint64(i)
		}
		hh.FillUpTo32()

		numItems := uint64(len(i.AttestingIndices))
		if ssz.EnableVectorizedHTR {
			hh.MerkleizeWithMixinVectorizedHTR(subIndx, numItems, ssz.CalculateLimit(2048, numItems, 8))
		} else {
			hh.MerkleizeWithMixin(subIndx, numItems, ssz.CalculateLimit(2048, numItems, 8))
		}
	}

	// Field (1) 'Data'
	if err = i.Data.HashTreeRootWith(hh); err != nil {
		return
	}

	// Field (2) 'Signature'
	if size := len(i.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	hh.PutBytes(i.Signature)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the SyncAggregate object
func (s *SyncAggregate) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(s)
}

// MarshalSSZTo ssz marshals the SyncAggregate object to a target array
func (s *SyncAggregate) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'SyncCommitteeBits'
	if size := len(s.SyncCommitteeBits); size != 64 {
		err = ssz.ErrBytesLengthFn("--.SyncCommitteeBits", size, 64)
		return
	}
	dst = append(dst, s.SyncCommitteeBits...)

	// Field (1) 'SyncCommitteeSignature'
	if size := len(s.SyncCommitteeSignature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.SyncCommitteeSignature", size, 96)
		return
	}
	dst = append(dst, s.SyncCommitteeSignature...)

	return
}

// UnmarshalSSZ ssz unmarshals the SyncAggregate object
func (s *SyncAggregate) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 160 {
		return ssz.ErrSize
	}

	// Field (0) 'SyncCommitteeBits'
	if cap(s.SyncCommitteeBits) == 0 {
		s.SyncCommitteeBits = make([]byte, 0, len(buf[0:64]))
	}
	s.SyncCommitteeBits = append(s.SyncCommitteeBits, buf[0:64]...)

	// Field (1) 'SyncCommitteeSignature'
	if cap(s.SyncCommitteeSignature) == 0 {
		s.SyncCommitteeSignature = make([]byte, 0, len(buf[64:160]))
	}
	s.SyncCommitteeSignature = append(s.SyncCommitteeSignature, buf[64:160]...)

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the SyncAggregate object
func (s *SyncAggregate) SizeSSZ() (size int) {
	size = 160
	return
}

// HashTreeRoot ssz hashes the SyncAggregate object
func (s *SyncAggregate) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(s)
}

// HashTreeRootWith ssz hashes the SyncAggregate object with a hasher
func (s *SyncAggregate) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'SyncCommitteeBits'
	if size := len(s.SyncCommitteeBits); size != 64 {
		err = ssz.ErrBytesLengthFn("--.SyncCommitteeBits", size, 64)
		return
	}
	hh.PutBytes(s.SyncCommitteeBits)

	// Field (1) 'SyncCommitteeSignature'
	if size := len(s.SyncCommitteeSignature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.SyncCommitteeSignature", size, 96)
		return
	}
	hh.PutBytes(s.SyncCommitteeSignature)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the Deposit_Data object
func (d *Deposit_Data) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(d)
}

// MarshalSSZTo ssz marshals the Deposit_Data object to a target array
func (d *Deposit_Data) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'Pubkey'
	if size := len(d.Pubkey); size != 48 {
		err = ssz.ErrBytesLengthFn("--.Pubkey", size, 48)
		return
	}
	dst = append(dst, d.Pubkey...)

	// Field (1) 'WithdrawalCredentials'
	if size := len(d.WithdrawalCredentials); size != 32 {
		err = ssz.ErrBytesLengthFn("--.WithdrawalCredentials", size, 32)
		return
	}
	dst = append(dst, d.WithdrawalCredentials...)

	// Field (2) 'Amount'
	dst = ssz.MarshalUint64(dst, d.Amount)

	// Field (3) 'Signature'
	if size := len(d.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	dst = append(dst, d.Signature...)

	return
}

// UnmarshalSSZ ssz unmarshals the Deposit_Data object
func (d *Deposit_Data) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 184 {
		return ssz.ErrSize
	}

	// Field (0) 'Pubkey'
	if cap(d.Pubkey) == 0 {
		d.Pubkey = make([]byte, 0, len(buf[0:48]))
	}
	d.Pubkey = append(d.Pubkey, buf[0:48]...)

	// Field (1) 'WithdrawalCredentials'
	if cap(d.WithdrawalCredentials) == 0 {
		d.WithdrawalCredentials = make([]byte, 0, len(buf[48:80]))
	}
	d.WithdrawalCredentials = append(d.WithdrawalCredentials, buf[48:80]...)

	// Field (2) 'Amount'
	d.Amount = ssz.UnmarshallUint64(buf[80:88])

	// Field (3) 'Signature'
	if cap(d.Signature) == 0 {
		d.Signature = make([]byte, 0, len(buf[88:184]))
	}
	d.Signature = append(d.Signature, buf[88:184]...)

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the Deposit_Data object
func (d *Deposit_Data) SizeSSZ() (size int) {
	size = 184
	return
}

// HashTreeRoot ssz hashes the Deposit_Data object
func (d *Deposit_Data) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(d)
}

// HashTreeRootWith ssz hashes the Deposit_Data object with a hasher
func (d *Deposit_Data) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Pubkey'
	if size := len(d.Pubkey); size != 48 {
		err = ssz.ErrBytesLengthFn("--.Pubkey", size, 48)
		return
	}
	hh.PutBytes(d.Pubkey)

	// Field (1) 'WithdrawalCredentials'
	if size := len(d.WithdrawalCredentials); size != 32 {
		err = ssz.ErrBytesLengthFn("--.WithdrawalCredentials", size, 32)
		return
	}
	hh.PutBytes(d.WithdrawalCredentials)

	// Field (2) 'Amount'
	hh.PutUint64(d.Amount)

	// Field (3) 'Signature'
	if size := len(d.Signature); size != 96 {
		err = ssz.ErrBytesLengthFn("--.Signature", size, 96)
		return
	}
	hh.PutBytes(d.Signature)

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}

// MarshalSSZ ssz marshals the Validator object
func (v *Validator) MarshalSSZ() ([]byte, error) {
	return ssz.MarshalSSZ(v)
}

// MarshalSSZTo ssz marshals the Validator object to a target array
func (v *Validator) MarshalSSZTo(buf []byte) (dst []byte, err error) {
	dst = buf

	// Field (0) 'Pubkey'
	if size := len(v.Pubkey); size != 48 {
		err = ssz.ErrBytesLengthFn("--.Pubkey", size, 48)
		return
	}
	dst = append(dst, v.Pubkey...)

	// Field (1) 'WithdrawalCredentials'
	if size := len(v.WithdrawalCredentials); size != 32 {
		err = ssz.ErrBytesLengthFn("--.WithdrawalCredentials", size, 32)
		return
	}
	dst = append(dst, v.WithdrawalCredentials...)

	// Field (2) 'EffectiveBalance'
	dst = ssz.MarshalUint64(dst, v.EffectiveBalance)

	// Field (3) 'Slashed'
	dst = ssz.MarshalBool(dst, v.Slashed)

	// Field (4) 'ActivationEligibilityEpoch'
	dst = ssz.MarshalUint64(dst, uint64(v.ActivationEligibilityEpoch))

	// Field (5) 'ActivationEpoch'
	dst = ssz.MarshalUint64(dst, uint64(v.ActivationEpoch))

	// Field (6) 'ExitEpoch'
	dst = ssz.MarshalUint64(dst, uint64(v.ExitEpoch))

	// Field (7) 'WithdrawableEpoch'
	dst = ssz.MarshalUint64(dst, uint64(v.WithdrawableEpoch))

	return
}

// UnmarshalSSZ ssz unmarshals the Validator object
func (v *Validator) UnmarshalSSZ(buf []byte) error {
	var err error
	size := uint64(len(buf))
	if size != 121 {
		return ssz.ErrSize
	}

	// Field (0) 'Pubkey'
	if cap(v.Pubkey) == 0 {
		v.Pubkey = make([]byte, 0, len(buf[0:48]))
	}
	v.Pubkey = append(v.Pubkey, buf[0:48]...)

	// Field (1) 'WithdrawalCredentials'
	if cap(v.WithdrawalCredentials) == 0 {
		v.WithdrawalCredentials = make([]byte, 0, len(buf[48:80]))
	}
	v.WithdrawalCredentials = append(v.WithdrawalCredentials, buf[48:80]...)

	// Field (2) 'EffectiveBalance'
	v.EffectiveBalance = ssz.UnmarshallUint64(buf[80:88])

	// Field (3) 'Slashed'
	v.Slashed = ssz.UnmarshalBool(buf[88:89])

	// Field (4) 'ActivationEligibilityEpoch'
	v.ActivationEligibilityEpoch = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.Epoch(ssz.UnmarshallUint64(buf[89:97]))

	// Field (5) 'ActivationEpoch'
	v.ActivationEpoch = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.Epoch(ssz.UnmarshallUint64(buf[97:105]))

	// Field (6) 'ExitEpoch'
	v.ExitEpoch = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.Epoch(ssz.UnmarshallUint64(buf[105:113]))

	// Field (7) 'WithdrawableEpoch'
	v.WithdrawableEpoch = github_com_prysmaticlabs_prysm_v4_consensus_types_primitives.Epoch(ssz.UnmarshallUint64(buf[113:121]))

	return err
}

// SizeSSZ returns the ssz encoded size in bytes for the Validator object
func (v *Validator) SizeSSZ() (size int) {
	size = 121
	return
}

// HashTreeRoot ssz hashes the Validator object
func (v *Validator) HashTreeRoot() ([32]byte, error) {
	return ssz.HashWithDefaultHasher(v)
}

// HashTreeRootWith ssz hashes the Validator object with a hasher
func (v *Validator) HashTreeRootWith(hh *ssz.Hasher) (err error) {
	indx := hh.Index()

	// Field (0) 'Pubkey'
	if size := len(v.Pubkey); size != 48 {
		err = ssz.ErrBytesLengthFn("--.Pubkey", size, 48)
		return
	}
	hh.PutBytes(v.Pubkey)

	// Field (1) 'WithdrawalCredentials'
	if size := len(v.WithdrawalCredentials); size != 32 {
		err = ssz.ErrBytesLengthFn("--.WithdrawalCredentials", size, 32)
		return
	}
	hh.PutBytes(v.WithdrawalCredentials)

	// Field (2) 'EffectiveBalance'
	hh.PutUint64(v.EffectiveBalance)

	// Field (3) 'Slashed'
	hh.PutBool(v.Slashed)

	// Field (4) 'ActivationEligibilityEpoch'
	hh.PutUint64(uint64(v.ActivationEligibilityEpoch))

	// Field (5) 'ActivationEpoch'
	hh.PutUint64(uint64(v.ActivationEpoch))

	// Field (6) 'ExitEpoch'
	hh.PutUint64(uint64(v.ExitEpoch))

	// Field (7) 'WithdrawableEpoch'
	hh.PutUint64(uint64(v.WithdrawableEpoch))

	if ssz.EnableVectorizedHTR {
		hh.MerkleizeVectorizedHTR(indx)
	} else {
		hh.Merkleize(indx)
	}
	return
}
