# Checksums

Checksums for each build are included in the [release notes](https://github.com/status-im/nimbus-eth2/releases/). Please make sure you get into the habit of verifying these 🙏

For those of you who are unfamiliar, a [checksum](https://en.wikipedia.org/wiki/Checksum) is a special type of [hash](https://en.wikipedia.org/wiki/Hash_function) used to verify the integrity of a file.
Verifying a checksum ensures there was no corruption or manipulation during the download and that the file was downloaded completely and correctly.
For a short and simple guide on how to do so, [see here](https://www.devdungeon.com/content/how-verify-checksum).

In the case of the [v1.1.0](https://github.com/status-im/nimbus-eth2/releases/tag/v1.1.0) release for example, the SHA512 checksums are:

```
# Linux AMD64
8d553ea5422645b5f06001e7f47051706ae5cffd8d88c45e4669939f3abb6caf41a2477431fce3e647265cdb4f8671fa360d392f423ac68ffb9459607eaab462  nimbus_beacon_node
# Linux ARM64
93ffd03a0ce67f7d035e3dc45e97de3c2c9a05a8dd0c6d5f45402ddb04404dc3cf15b80fee972f34152ef171ce97c40f794448bc779ca056081c945f71f19788  nimbus_beacon_node
# Linux ARM
f2e75f3fae2aea0a9f8d45861d52b0e2546c3990f453b509fab538692d18c64e65f58441c5492064fc371e0bc77de6bab970e05394cfd124417601b55cb4a825  nimbus_beacon_node
# Windows AMD64
fd68c8792ea60c2c72e9c2201745f9698bfd1dae4af4fa9e1683f082109045efebd1d80267f13cafeb1cd7414dc0f589a8a73f12161ac2758779369289d5a832  nimbus_beacon_node

```

