# NBC Threat model

NBC primarily targets resource restricted devices like Raspberry Pi or smartphones to desktop computers.

We focus on:
- remote attacks

This includes but not limited to:
- denial-of-services
- retrieving a secret key
  - via software defect or misuse of libraries (cryptography, networking)
  - or poor key management practices or UI or documentation confusing the user
- collusion of peers (eclipse, surround voting, ...)
- loss of funds

In particular, we do not defend against a malicious cloud provider which would offer
a “Rent-a-Raspberry-Pi” service for validators and would subsequently engage in attacks against
those validators, the implest being, taking the validator offline when it's their duty time.

Sensitive data:
1. Signing key: each validator has a secret signing key used to sign attestation and blocks with 32 ETH at stake (about 7500 USD at the current rate)
   Each beacon node instance can have dozens to hundreds of validators attached.
   Leaking the signing key would allow an attacker to double-vote with the key, leading to slashing and ultimately ejecting the validator
   once its stake reaches below 16 ETH.
   The signing key must be present in memory as a validator may have signing duties every 6 seconds
2. Withdrawal key: a withdrawal key allows withdrawing the stake.
   A withdrawal key is unnecessary during day-to-day operation and can be stored in cold storage, possibly hardware wallet
3. IP address: if a validator IP address leaks, they might be subject to target DoS attacks taking their node offline and making them miss their duties.
   In a regular setting, the network will have "relayer"/"listener" nodes and validator nodes that shouldn't be distinguishable.
4. Random number generation:
   - Strong recommendations to generate the withdrawal key offline.
   - The RNG is used in particular to select which peer to connect to from a pool of candidates.

## Cryptographic libraries

A review in in progress to select BLS signature backend.

See [https://notes.status.im/nim-bls-curve-backends#Threat-model](https://notes.status.im/nim-bls-curve-backends#Threat-model)

## Resources

Surround vote detection (not in audit scope): [https://github.com/protolambda/eth2-surround](https://github.com/protolambda/eth2-surround)
