# Nimbus build system & dependencies

## Build system

### NBC repo

`nimbus-eth2` uses a build system based on makefiles.
Usage is described in the README.

In particular a `env.sh` scripts is provided that setups the environment variable
expected.

### Libraries

Library repositories uses the official package manager called `nimble`
for building and testing.

In particular, we use by convention the following command to run the test suite via nimble task system:

```Nim
nimble test
```

The details are implemented in `<package name>.nimble` at the root of the repository.

The continuous integration setup for Travis, Azure Pipelines and/or Appveyor
are also setting up a Nim environment from scratch.

## Package dependencies

### NBC repo

For the `nimbus-eth2` application, all dependencies are vendored
in the `vendor` folder.

With regards to the audit scope we have the following dependencies:

#### All

- Async
  - asynctools
  - nim-chronos
- Logging
  - jswebsockets
  - karax
  - nim-chronicles
  - nim-chronicles-tail (devtool, out-of-audit-scope)
  - nim-libbacktrace
  - websocket.nim
  - nim-protobuf-serialization
  - nim-rocksdb
- CLI interface
  - nim-confutils
  - nim-prompt
  - nim-unicodedb
- Metrics
  - nim-metrics (the server endpoint is out-of-audit-scope)
- Helpers
  - nim-stew
  - nim-testutils (fuzzing)
  - nimYAML (should be test only)

#### Network core

- Cryptography
  - nim-bearssl
  - nim-secp256k1
  - nimcrypto
- Networking & Discovery
  - nim-eth
  - nim-libp2p
  - nim-nat-traversal
- Serialization
  - nim-faststreams
  - nim-serialization
  - nim-snappy
- BigInt
  - nim-stint (Note: one of the main use is 256-bit bloomfilter, a dedicated library should be used instead)

#### ETH2 Specification core

- Cryptography
  - nim-blscurve
- Database
  - nim-sqlite3-abi
- Eth1 monitoring
  - nim-web3
- Build system
  - nimbus-build-system

#### Validator core

- Cryptography
  - nim-blscurve
- RPC
  - news
  - nim-http-utils
  - nim-json-rpc
  - nim-json-serialization
