# Generics and Static types

Nim types can be parametrized by types (generics) or compile-time values (static)

For example

```Nim
type
  MySeq[T] = object
    len, reserved: int
    data: ptr UncheckedArray[T]
```

The generics can be restricted

```Nim
type
  MySeq[T: int32 or int64] = object
    len, reserved: int
    data: ptr UncheckedArray[T]
```

With static types

```Nim
type
  SmallSeq[MaxLen: static int, T] = object
    len: int
    data: array[MaxLen, T]
```
