# Nim memory management

Nim memory management is on a per-type basis.

Plain objects and char and numerical types are allocated on the stack.

Sequences and strings are allocated on the heap but have value semantics.
They are copied on assignment

Ref types are allocated on the heap and have reference semantics, i.e. an unique instance
can be held by multiple variables and only when all those variables go out-of-scope is
the ref type discarded.

By default Nim uses a deferred reference counting GC. Additionally, if the type can lead
to cycles, Nim will add "mark-and-sweep" passes to collect them.

## Destructors

TODO

## Nim allocator

Nim GCs are backed by a TLSF allocator which allows Nim to provide soft real-time guarantees if needed.

## Analyzing memory leaks

Nim can be compiled with `-d:useMalloc` to bypass the TLSF allocator and directly use malloc/free

## References

- [https://nim-lang.org/docs/gc.html](https://nim-lang.org/docs/gc.html)

- [http://www.gii.upv.es/tlsf/](http://www.gii.upv.es/tlsf/)
