# Casting and low-level memory representation

## Conversions

Casting to a signed integer will lead to a range check.
Conversion to an unsigned integer even from a negative signed integer will NOT lead to a range check (https://github.com/nim-lang/RFCs/issues/175)
https://nim-lang.org/docs/manual.html#statements-and-expressions-type-conversions

## Casting integers

Unsigned integer casts behave like C.

Upcasting will lead to zero extension
Downcasting will lead to truncation

Signed integer ranges will not be checked with a cast.

## Casting to/from other types

Casting to or from any other types will be done through:

- union casts by default
- or C conversion if the type is a pointer.

In practice this means that the bit-pattern will be reinterpreted as the new type, similar to C++ reinterpret cast.
