# Key recovery


Generally, validator keystore files are generated alongside a *mnemonic*. If
the keystore and/or the keystore password are lost this mnemonic can
regenerate a new, equivalent keystore with a new password.

There are two ways to recover keys using the `lighthouse` CLI:

- `lighthouse account validator recover`: recover one or more EIP-2335 keystores from a mnemonic.
	These keys can be used directly in a validator client.
- `lighthouse account wallet recover`: recover an EIP-2386 wallet from a
	mnemonic.

## ⚠️ Warning

**Recovering validator keys from a mnemonic should only be used as a last
resort.** Key recovery entails significant risks:

- Exposing your mnemonic to a computer at any time puts it at risk of being
	compromised. Your mnemonic is **not encrypted** and is a target for theft.
- It's completely possible to regenerate a validator keypairs that is already active
	on some other validator client. Running the same keypairs on two different
	validator clients is very likely to result in slashing.

## Recover EIP-2335 validator keystores

A single mnemonic can generate a practically unlimited number of validator
keystores using an *index*. Generally, the first time you generate a keystore
you'll use index 0, the next time you'll use index 1, and so on. Using the same
index on the same mnemonic always results in the same validator keypair being
generated (see [EIP-2334](https://eips.ethereum.org/EIPS/eip-2334) for more
detail).


Using the `lighthouse account validator recover` command you can generate the
keystores that correspond to one or more indices in the mnemonic:

- `lighthouse account validator recover`: recover only index `0`.
- `lighthouse account validator recover --count 2`: recover indices `0, 1`.
- `lighthouse account validator recover --first-index 1`: recover only index `1`.
- `lighthouse account validator recover --first-index 1 --count 2`: recover indices `1, 2`.


For each of the indices recovered in the above commands, a directory will be
created in the `--validator-dir` location (default `~/.lighthouse/{network}/validators`)
which contains all the information necessary to run a validator using the
`lighthouse vc` command. The password to this new keystore will be placed in
the `--secrets-dir` (default `~/.lighthouse/{network}/secrets`).

where `network` is the name of the consensus layer network passed in the `--network` parameter (default is `mainnet`).

## Recover a EIP-2386 wallet

Instead of creating EIP-2335 keystores directly, an EIP-2386 wallet can be
generated from the mnemonic. This wallet can then be used to generate validator
keystores, if desired. For example, the following command will create an
encrypted wallet named `wally-recovered` from a mnemonic:

```
lighthouse account wallet recover --name wally-recovered
```

**⚠️ Warning:** the wallet will be created with a `nextaccount` value of `0`.
This means that if you have already generated `n` validators, then the next `n`
validators generated by this wallet will be duplicates. As mentioned
previously, running duplicate validators is likely to result in slashing.
