# Lighthouse Book

_Documentation for Lighthouse users and developers._

[![Chat Badge]][Chat Link]

[Chat Badge]: https://img.shields.io/badge/chat-discord-%237289da
[Chat Link]: https://discord.gg/cyAszAh

Lighthouse is an **Ethereum consensus client** that connects to other Ethereum consensus
clients to form a resilient and decentralized proof-of-stake blockchain.

We implement the specification as defined in the
[ethereum/consensus-specs](https://github.com/ethereum/consensus-specs) repository.

## Topics

You may read this book from start to finish, or jump to some of these topics:

- Follow the [Installation Guide](./installation.md) to install Lighthouse.
- Run your very [own beacon node](./run_a_node.md).
- Learn about [becoming a mainnet validator](./mainnet-validator.md).
- Get hacking with the [Development Environment Guide](./setup.md).
- Utilize the whole stack by starting a [local testnet](./setup.md#local-testnets).
- Query the [RESTful HTTP API](./api.md) using `curl`.


Prospective contributors can read the [Contributing](./contributing.md) section
to understand how we develop and test Lighthouse.

## About this Book

This book is open source, contribute at
[github.com/sigp/lighthouse/book](https://github.com/sigp/lighthouse/tree/unstable/book).

The Lighthouse CI/CD system maintains a hosted version of the `unstable` branch
at [lighthouse-book.sigmaprime.io](http://lighthouse-book.sigmaprime.io).
