# 📦 Installation

Lighthouse runs on Linux, macOS, and Windows.

There are three core methods to obtain the Lighthouse application:

- [Pre-built binaries](./installation-binaries.md).
- [Docker images](./docker.md).
- [Building from source](./installation-source.md).

Community-maintained additional installation methods:

- [Homebrew package](./homebrew.md).
- Arch Linux AUR packages: [source](https://aur.archlinux.org/packages/lighthouse-ethereum),
  [binary](https://aur.archlinux.org/packages/lighthouse-ethereum-bin).

Additionally, there are two extra guides for specific uses:

- [Raspberry Pi 4 guide](./pi.md).
- [Cross-compiling guide for developers](./cross-compiling.md).

## Minimum System Requirements

* Dual-core CPU, 2015 or newer
* 8 GB RAM
* 128 GB solid state storage
* 10 Mb/s download, 5 Mb/s upload broadband connection

For more information see [System Requirements](./system-requirements.md).

[WSL]: https://docs.microsoft.com/en-us/windows/wsl/about
